/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.model;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.SettingsConfiguration;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.configuration.SettingsConfigurationFieldType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStoredTaskSchema;

record SageMakerTaskSettings(@Nullable String customAttributes, @Nullable String enableExplanations, @Nullable String inferenceIdForDataCapture, @Nullable String sessionId, @Nullable String targetVariant, SageMakerStoredTaskSchema apiTaskSettings) implements TaskSettings
{
    static final String NAME = "sage_maker_task_settings";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String ENABLE_EXPLANATIONS = "enable_explanations";
    private static final String INFERENCE_ID = "inference_id";
    private static final String SESSION_ID = "session_id";
    private static final String TARGET_VARIANT = "target_variant";
    private static final TransportVersion ML_INFERENCE_SAGEMAKER = TransportVersion.fromName((String)"ml_inference_sagemaker");

    SageMakerTaskSettings(StreamInput in) throws IOException {
        this(in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), (SageMakerStoredTaskSchema)in.readNamedWriteable(SageMakerStoredTaskSchema.class));
    }

    public boolean isEmpty() {
        return this.customAttributes == null && this.enableExplanations == null && this.inferenceIdForDataCapture == null && this.sessionId == null && this.targetVariant == null && SageMakerStoredTaskSchema.NO_OP.equals(this.apiTaskSettings);
    }

    public SageMakerTaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        ValidationException validationException = new ValidationException();
        SageMakerTaskSettings updateTaskSettings = SageMakerTaskSettings.fromMap(newSettings, (SageMakerStoredTaskSchema)this.apiTaskSettings.updatedTaskSettings((Map)newSettings), validationException);
        validationException.throwIfValidationErrorsExist();
        return this.override(updateTaskSettings);
    }

    public SageMakerTaskSettings override(Map<String, Object> newSettings) {
        ValidationException validationException = new ValidationException();
        SageMakerTaskSettings updateTaskSettings = SageMakerTaskSettings.fromMap(newSettings, this.apiTaskSettings.override(newSettings), validationException);
        validationException.throwIfValidationErrorsExist();
        return this.override(updateTaskSettings);
    }

    private SageMakerTaskSettings override(SageMakerTaskSettings updateTaskSettings) {
        SageMakerStoredTaskSchema updatedExtraTaskSettings = updateTaskSettings.apiTaskSettings().equals(SageMakerStoredTaskSchema.NO_OP) ? this.apiTaskSettings : updateTaskSettings.apiTaskSettings();
        return new SageMakerTaskSettings(SageMakerTaskSettings.firstNotNullOrNull(updateTaskSettings.customAttributes(), this.customAttributes), SageMakerTaskSettings.firstNotNullOrNull(updateTaskSettings.enableExplanations(), this.enableExplanations), SageMakerTaskSettings.firstNotNullOrNull(updateTaskSettings.inferenceIdForDataCapture(), this.inferenceIdForDataCapture), SageMakerTaskSettings.firstNotNullOrNull(updateTaskSettings.sessionId(), this.sessionId), SageMakerTaskSettings.firstNotNullOrNull(updateTaskSettings.targetVariant(), this.targetVariant), updatedExtraTaskSettings);
    }

    private static <T> T firstNotNullOrNull(T first, T second) {
        return first != null ? first : second;
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "should never be called when supportsVersion is used";
        return ML_INFERENCE_SAGEMAKER;
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.supports(ML_INFERENCE_SAGEMAKER);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.customAttributes);
        out.writeOptionalString(this.enableExplanations);
        out.writeOptionalString(this.inferenceIdForDataCapture);
        out.writeOptionalString(this.sessionId);
        out.writeOptionalString(this.targetVariant);
        out.writeNamedWriteable((NamedWriteable)this.apiTaskSettings);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        SageMakerTaskSettings.optionalField(CUSTOM_ATTRIBUTES, this.customAttributes, builder);
        SageMakerTaskSettings.optionalField(ENABLE_EXPLANATIONS, this.enableExplanations, builder);
        SageMakerTaskSettings.optionalField(INFERENCE_ID, this.inferenceIdForDataCapture, builder);
        SageMakerTaskSettings.optionalField(SESSION_ID, this.sessionId, builder);
        SageMakerTaskSettings.optionalField(TARGET_VARIANT, this.targetVariant, builder);
        this.apiTaskSettings.toXContent(builder, params);
        return builder.endObject();
    }

    private static <T> void optionalField(String name, T value, XContentBuilder builder) throws IOException {
        if (value != null) {
            builder.field(name, value);
        }
    }

    public static SageMakerTaskSettings fromMap(Map<String, Object> taskSettingsMap, SageMakerStoredTaskSchema apiTaskSettings, ValidationException validationException) {
        String customAttributes = ServiceUtils.extractOptionalString(taskSettingsMap, CUSTOM_ATTRIBUTES, "task_settings", validationException);
        String enableExplanations = ServiceUtils.extractOptionalString(taskSettingsMap, ENABLE_EXPLANATIONS, "task_settings", validationException);
        String inferenceIdForDataCapture = ServiceUtils.extractOptionalString(taskSettingsMap, INFERENCE_ID, "task_settings", validationException);
        String sessionId = ServiceUtils.extractOptionalString(taskSettingsMap, SESSION_ID, "task_settings", validationException);
        String targetVariant = ServiceUtils.extractOptionalString(taskSettingsMap, TARGET_VARIANT, "task_settings", validationException);
        return new SageMakerTaskSettings(customAttributes, enableExplanations, inferenceIdForDataCapture, sessionId, targetVariant, apiTaskSettings);
    }

    static Stream<Map.Entry<String, SettingsConfiguration>> configuration(EnumSet<TaskType> supportedTaskTypes) {
        return Stream.of(Map.entry(CUSTOM_ATTRIBUTES, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("An opaque informational value forwarded as-is to the model within SageMaker.").setLabel("Custom Attributes").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(ENABLE_EXPLANATIONS, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("JMESPath expression overriding the ClarifyingExplainerConfig in the SageMaker Endpoint Configuration.").setLabel("Enable Explanations").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(INFERENCE_ID, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("Informational identifying for auditing requests within the SageMaker Endpoint.").setLabel("Inference ID").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(SESSION_ID, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("Creates or reuses an existing Session for SageMaker stateful models.").setLabel("Session ID").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()), Map.entry(TARGET_VARIANT, new SettingsConfiguration.Builder(supportedTaskTypes).setDescription("The production variant when calling the SageMaker Endpoint").setLabel("Target Variant").setRequired(Boolean.valueOf(false)).setSensitive(Boolean.valueOf(false)).setUpdatable(Boolean.valueOf(false)).setType(SettingsConfigurationFieldType.STRING).build()));
    }
}

