/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.embeddings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.openai.OpenAiTaskSettings;

public class OpenAiEmbeddingsTaskSettings
extends OpenAiTaskSettings<OpenAiEmbeddingsTaskSettings> {
    public static final String NAME = "openai_embeddings_task_settings";
    static final TransportVersion INFERENCE_API_OPENAI_EMBEDDINGS_HEADERS = TransportVersion.fromName((String)"inference_api_openai_embeddings_headers");

    public OpenAiEmbeddingsTaskSettings(Map<String, Object> map) {
        super(map);
    }

    public OpenAiEmbeddingsTaskSettings(@Nullable String user, @Nullable Map<String, String> headers) {
        super(user, headers);
    }

    public OpenAiEmbeddingsTaskSettings(StreamInput in) throws IOException {
        super(OpenAiEmbeddingsTaskSettings.readTaskSettingsFromStream(in));
    }

    private static OpenAiTaskSettings.Settings readTaskSettingsFromStream(StreamInput in) throws IOException {
        String user;
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            user = in.readOptionalString();
        } else {
            String discard = in.readString();
            user = in.readOptionalString();
        }
        Map headers = in.getTransportVersion().supports(INFERENCE_API_OPENAI_EMBEDDINGS_HEADERS) ? in.readOptionalImmutableMap(StreamInput::readString, StreamInput::readString) : null;
        return OpenAiEmbeddingsTaskSettings.createSettings(user, headers);
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_12_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
            out.writeOptionalString(this.user());
        } else {
            out.writeString("m");
            out.writeOptionalString(this.user());
        }
        if (out.getTransportVersion().supports(INFERENCE_API_OPENAI_EMBEDDINGS_HEADERS)) {
            out.writeOptionalMap(this.headers(), StreamOutput::writeString, StreamOutput::writeString);
        }
    }

    @Override
    protected OpenAiEmbeddingsTaskSettings create(@Nullable String user, @Nullable Map<String, String> headers) {
        return new OpenAiEmbeddingsTaskSettings(user, headers);
    }
}

