/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.openai.completion;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.openai.OpenAiModel;
import org.elasticsearch.xpack.inference.services.openai.action.OpenAiActionVisitor;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionServiceSettings;
import org.elasticsearch.xpack.inference.services.openai.completion.OpenAiChatCompletionTaskSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class OpenAiChatCompletionModel
extends OpenAiModel {
    public static OpenAiChatCompletionModel of(OpenAiChatCompletionModel model, Map<String, Object> taskSettings) {
        if (taskSettings == null || taskSettings.isEmpty()) {
            return model;
        }
        return new OpenAiChatCompletionModel(model, (OpenAiChatCompletionTaskSettings)model.getTaskSettings().updatedTaskSettings((Map)taskSettings));
    }

    public static OpenAiChatCompletionModel of(OpenAiChatCompletionModel model, UnifiedCompletionRequest request) {
        OpenAiChatCompletionServiceSettings originalModelServiceSettings = model.getServiceSettings();
        OpenAiChatCompletionServiceSettings overriddenServiceSettings = new OpenAiChatCompletionServiceSettings(Objects.requireNonNullElse(request.model(), originalModelServiceSettings.modelId()), originalModelServiceSettings.uri(), originalModelServiceSettings.organizationId(), originalModelServiceSettings.maxInputTokens(), originalModelServiceSettings.rateLimitSettings());
        return new OpenAiChatCompletionModel(model.getInferenceEntityId(), model.getTaskType(), model.getConfigurations().getService(), overriddenServiceSettings, model.getTaskSettings(), model.getSecretSettings());
    }

    public OpenAiChatCompletionModel(String inferenceEntityId, TaskType taskType, String service, Map<String, Object> serviceSettings, Map<String, Object> taskSettings, @Nullable Map<String, Object> secrets, ConfigurationParseContext context) {
        this(inferenceEntityId, taskType, service, OpenAiChatCompletionServiceSettings.fromMap(serviceSettings, context), new OpenAiChatCompletionTaskSettings(taskSettings), DefaultSecretSettings.fromMap(secrets));
    }

    OpenAiChatCompletionModel(String modelId, TaskType taskType, String service, OpenAiChatCompletionServiceSettings serviceSettings, OpenAiChatCompletionTaskSettings taskSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(modelId, taskType, service, (ServiceSettings)serviceSettings, (TaskSettings)taskSettings), new ModelSecrets((SecretSettings)secrets), serviceSettings, secrets, RequestUtils.buildUri(serviceSettings.uri(), "openai", (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)OpenAiChatCompletionModel::buildDefaultUri)));
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.openai.com").setPathSegments(new String[]{"v1", "chat", "completions"}).build();
    }

    private OpenAiChatCompletionModel(OpenAiChatCompletionModel originalModel, OpenAiChatCompletionTaskSettings taskSettings) {
        super((OpenAiModel)originalModel, (TaskSettings)taskSettings);
    }

    public OpenAiChatCompletionServiceSettings getServiceSettings() {
        return (OpenAiChatCompletionServiceSettings)super.getServiceSettings();
    }

    public OpenAiChatCompletionTaskSettings getTaskSettings() {
        return (OpenAiChatCompletionTaskSettings)super.getTaskSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public ExecutableAction accept(OpenAiActionVisitor creator, Map<String, Object> taskSettings) {
        return creator.create(this, taskSettings);
    }
}

