/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.llama.request.completion;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.external.request.RequestUtils;
import org.elasticsearch.xpack.inference.services.llama.completion.LlamaChatCompletionModel;
import org.elasticsearch.xpack.inference.services.llama.request.completion.LlamaChatCompletionRequestEntity;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class LlamaChatCompletionRequest
implements Request {
    private final LlamaChatCompletionModel model;
    private final UnifiedChatInput chatInput;

    public LlamaChatCompletionRequest(UnifiedChatInput chatInput, LlamaChatCompletionModel model) {
        this.chatInput = Objects.requireNonNull(chatInput);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.model.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new LlamaChatCompletionRequestEntity(this.chatInput, this.model)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        httpPost.setHeader("Content-Type", XContentType.JSON.mediaTypeWithoutParameters());
        SecretSettings secretSettings = this.model.getSecretSettings();
        if (secretSettings instanceof DefaultSecretSettings) {
            DefaultSecretSettings secretSettings2 = (DefaultSecretSettings)secretSettings;
            httpPost.setHeader(RequestUtils.createAuthBearerHeader(secretSettings2.apiKey()));
        }
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public URI getURI() {
        return this.model.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public boolean isStreaming() {
        return this.chatInput.stream();
    }
}

