/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.jinaai.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.Strings;
import org.elasticsearch.inference.InputType;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.jinaai.JinaAIAccount;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingType;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.jinaai.embeddings.JinaAIEmbeddingsTaskSettings;
import org.elasticsearch.xpack.inference.services.jinaai.request.JinaAIEmbeddingsRequestEntity;
import org.elasticsearch.xpack.inference.services.jinaai.request.JinaAIRequest;

public class JinaAIEmbeddingsRequest
extends JinaAIRequest {
    private final JinaAIAccount account;
    private final List<String> input;
    private final InputType inputType;
    private final JinaAIEmbeddingsTaskSettings taskSettings;
    private final String model;
    private final String inferenceEntityId;
    private final JinaAIEmbeddingType embeddingType;

    public JinaAIEmbeddingsRequest(List<String> input, InputType inputType, JinaAIEmbeddingsModel embeddingsModel) {
        Objects.requireNonNull(embeddingsModel);
        this.account = JinaAIAccount.of(embeddingsModel, (CheckedSupplier<URI, URISyntaxException>)((CheckedSupplier)JinaAIEmbeddingsRequest::buildDefaultUri));
        this.input = Objects.requireNonNull(input);
        this.inputType = inputType;
        this.taskSettings = embeddingsModel.getTaskSettings();
        this.model = embeddingsModel.getServiceSettings().getCommonSettings().modelId();
        this.embeddingType = embeddingsModel.getServiceSettings().getEmbeddingType();
        this.inferenceEntityId = embeddingsModel.getInferenceEntityId();
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpPost = new HttpPost(this.account.uri());
        ByteArrayEntity byteEntity = new ByteArrayEntity(Strings.toString((ToXContent)new JinaAIEmbeddingsRequestEntity(this.input, this.inputType, this.taskSettings, this.model, this.embeddingType)).getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)byteEntity);
        JinaAIEmbeddingsRequest.decorateWithAuthHeader(httpPost, this.account);
        return new HttpRequest((HttpRequestBase)httpPost, this.getInferenceEntityId());
    }

    @Override
    public String getInferenceEntityId() {
        return this.inferenceEntityId;
    }

    @Override
    public URI getURI() {
        return this.account.uri();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }

    public JinaAIEmbeddingType getEmbeddingType() {
        return this.embeddingType;
    }

    public static URI buildDefaultUri() throws URISyntaxException {
        return new URIBuilder().setScheme("https").setHost("api.jina.ai").setPathSegments(new String[]{"v1", "embeddings"}).build();
    }
}

