/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elasticsearch;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalServiceSettings;

public class ElasticRerankerServiceSettings
extends ElasticsearchInternalServiceSettings {
    public static final String NAME = "elastic_reranker_service_settings";
    public static final String LONG_DOCUMENT_STRATEGY = "long_document_strategy";
    public static final String MAX_CHUNKS_PER_DOC = "max_chunks_per_doc";
    private static final TransportVersion ELASTIC_RERANKER_CHUNKING_CONFIGURATION = TransportVersion.fromName((String)"elastic_reranker_chunking_configuration");
    private final LongDocumentStrategy longDocumentStrategy;
    private final Integer maxChunksPerDoc;

    public static ElasticRerankerServiceSettings defaultEndpointSettings() {
        return new ElasticRerankerServiceSettings(null, 1, ".rerank-v1", new AdaptiveAllocationsSettings(Boolean.TRUE, Integer.valueOf(0), Integer.valueOf(32)));
    }

    public ElasticRerankerServiceSettings(ElasticsearchInternalServiceSettings other, LongDocumentStrategy longDocumentStrategy, Integer maxChunksPerDoc) {
        super(other);
        this.longDocumentStrategy = longDocumentStrategy;
        this.maxChunksPerDoc = maxChunksPerDoc;
    }

    private ElasticRerankerServiceSettings(Integer numAllocations, int numThreads, String modelId, AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
        super(numAllocations, numThreads, modelId, adaptiveAllocationsSettings, null);
        this.longDocumentStrategy = null;
        this.maxChunksPerDoc = null;
    }

    protected ElasticRerankerServiceSettings(Integer numAllocations, int numThreads, String modelId, AdaptiveAllocationsSettings adaptiveAllocationsSettings, LongDocumentStrategy longDocumentStrategy, Integer maxChunksPerDoc) {
        super(numAllocations, numThreads, modelId, adaptiveAllocationsSettings, null);
        this.longDocumentStrategy = longDocumentStrategy;
        this.maxChunksPerDoc = maxChunksPerDoc;
    }

    public ElasticRerankerServiceSettings(StreamInput in) throws IOException {
        super(in);
        if (in.getTransportVersion().supports(ELASTIC_RERANKER_CHUNKING_CONFIGURATION)) {
            this.longDocumentStrategy = (LongDocumentStrategy)in.readOptionalEnum(LongDocumentStrategy.class);
            this.maxChunksPerDoc = in.readOptionalInt();
        } else {
            this.longDocumentStrategy = null;
            this.maxChunksPerDoc = null;
        }
    }

    public static ElasticRerankerServiceSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        ElasticsearchInternalServiceSettings.Builder baseSettings = ElasticsearchInternalServiceSettings.fromMap(map, validationException);
        LongDocumentStrategy longDocumentStrategy = ServiceUtils.extractOptionalEnum(map, LONG_DOCUMENT_STRATEGY, "service_settings", LongDocumentStrategy::fromString, EnumSet.allOf(LongDocumentStrategy.class), validationException);
        Integer maxChunksPerDoc = ServiceUtils.extractOptionalPositiveInteger(map, MAX_CHUNKS_PER_DOC, "service_settings", validationException);
        if (maxChunksPerDoc != null && (longDocumentStrategy == null || longDocumentStrategy == LongDocumentStrategy.TRUNCATE)) {
            validationException.addValidationError("The [max_chunks_per_doc] setting requires [long_document_strategy] to be set to [chunk]");
        }
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new ElasticRerankerServiceSettings(baseSettings.build(), longDocumentStrategy, maxChunksPerDoc);
    }

    public LongDocumentStrategy getLongDocumentStrategy() {
        return this.longDocumentStrategy;
    }

    public Integer getMaxChunksPerDoc() {
        return this.maxChunksPerDoc;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().supports(ELASTIC_RERANKER_CHUNKING_CONFIGURATION)) {
            out.writeOptionalEnum((Enum)this.longDocumentStrategy);
            out.writeOptionalInt(this.maxChunksPerDoc);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.addInternalSettingsToXContent(builder, params);
        if (this.longDocumentStrategy != null) {
            builder.field(LONG_DOCUMENT_STRATEGY, this.longDocumentStrategy.strategyName);
        }
        if (this.maxChunksPerDoc != null) {
            builder.field(MAX_CHUNKS_PER_DOC, this.maxChunksPerDoc);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static enum LongDocumentStrategy {
        CHUNK("chunk"),
        TRUNCATE("truncate");

        public final String strategyName;

        private LongDocumentStrategy(String strategyName) {
            this.strategyName = strategyName;
        }

        public static LongDocumentStrategy fromString(String name) {
            return LongDocumentStrategy.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }
    }
}

