/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic.action;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.EmbeddingsInput;
import org.elasticsearch.xpack.inference.external.http.sender.GenericRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.QueryAndDocsInputs;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceDenseTextEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.external.response.elastic.ElasticInferenceServiceRerankResponseEntity;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceResponseHandler;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceServiceSparseEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.elastic.action.ElasticInferenceServiceActionVisitor;
import org.elasticsearch.xpack.inference.services.elastic.densetextembeddings.ElasticInferenceServiceDenseTextEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceDenseTextEmbeddingsRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRequest;
import org.elasticsearch.xpack.inference.services.elastic.request.ElasticInferenceServiceRerankRequest;
import org.elasticsearch.xpack.inference.services.elastic.rerank.ElasticInferenceServiceRerankModel;
import org.elasticsearch.xpack.inference.services.elastic.sparseembeddings.ElasticInferenceServiceSparseEmbeddingsModel;
import org.elasticsearch.xpack.inference.telemetry.TraceContext;

public class ElasticInferenceServiceActionCreator
implements ElasticInferenceServiceActionVisitor {
    static final ResponseHandler DENSE_TEXT_EMBEDDINGS_HANDLER = new ElasticInferenceServiceResponseHandler("elastic dense text embedding", ElasticInferenceServiceDenseTextEmbeddingsResponseEntity::fromResponse);
    static final ResponseHandler RERANK_HANDLER = new ElasticInferenceServiceResponseHandler("elastic rerank", (request, response) -> ElasticInferenceServiceRerankResponseEntity.fromResponse(response));
    private final Sender sender;
    private final ServiceComponents serviceComponents;
    private final TraceContext traceContext;

    public ElasticInferenceServiceActionCreator(Sender sender, ServiceComponents serviceComponents, TraceContext traceContext) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
        this.traceContext = traceContext;
    }

    @Override
    public ExecutableAction create(ElasticInferenceServiceSparseEmbeddingsModel model) {
        ElasticInferenceServiceSparseEmbeddingsRequestManager requestManager = new ElasticInferenceServiceSparseEmbeddingsRequestManager(model, this.serviceComponents, this.traceContext);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(Strings.format((String)"%s sparse embeddings", (Object[])new Object[]{"Elastic Inference Service"}));
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(ElasticInferenceServiceRerankModel model) {
        ThreadPool threadPool = this.serviceComponents.threadPool();
        GenericRequestManager<QueryAndDocsInputs> requestManager = new GenericRequestManager<QueryAndDocsInputs>(threadPool, model, RERANK_HANDLER, rerankInput -> new ElasticInferenceServiceRerankRequest(rerankInput.getQuery(), rerankInput.getChunks(), rerankInput.getTopN(), model, this.traceContext, ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(threadPool.getThreadContext())), QueryAndDocsInputs.class);
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(Strings.format((String)"%s rerank", (Object[])new Object[]{"Elastic Inference Service"}));
        return new SenderExecutableAction(this.sender, requestManager, errorMessage);
    }

    @Override
    public ExecutableAction create(ElasticInferenceServiceDenseTextEmbeddingsModel model) {
        ThreadPool threadPool = this.serviceComponents.threadPool();
        GenericRequestManager<EmbeddingsInput> manager = new GenericRequestManager<EmbeddingsInput>(threadPool, model, DENSE_TEXT_EMBEDDINGS_HANDLER, embeddingsInput -> new ElasticInferenceServiceDenseTextEmbeddingsRequest(model, embeddingsInput.getInputs(), this.traceContext, ElasticInferenceServiceRequest.extractRequestMetadataFromThreadContext(threadPool.getThreadContext()), embeddingsInput.getInputType()), EmbeddingsInput.class);
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("Elastic dense text embeddings");
        return new SenderExecutableAction(this.sender, manager, failedToSendRequestErrorMessage);
    }
}

