/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.elastic;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class ElasticInferenceServiceSettings {
    public static final String ELASTIC_INFERENCE_SERVICE_SSL_CONFIGURATION_PREFIX = "xpack.inference.elastic.http.ssl.";
    @Deprecated
    static final Setting<String> EIS_GATEWAY_URL = Setting.simpleString((String)"xpack.inference.eis.gateway.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> ELASTIC_INFERENCE_SERVICE_URL = Setting.simpleString((String)"xpack.inference.elastic.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<Boolean> PERIODIC_AUTHORIZATION_ENABLED = Setting.boolSetting((String)"xpack.inference.elastic.periodic_authorization_enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final TimeValue DEFAULT_AUTH_REQUEST_INTERVAL = TimeValue.timeValueMinutes((long)10L);
    static final Setting<TimeValue> AUTHORIZATION_REQUEST_INTERVAL = Setting.timeSetting((String)"xpack.inference.elastic.authorization_request_interval", (TimeValue)DEFAULT_AUTH_REQUEST_INTERVAL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private static final TimeValue DEFAULT_AUTH_REQUEST_JITTER = TimeValue.timeValueMinutes((long)5L);
    static final Setting<TimeValue> MAX_AUTHORIZATION_REQUEST_JITTER = Setting.timeSetting((String)"xpack.inference.elastic.max_authorization_request_jitter", (TimeValue)DEFAULT_AUTH_REQUEST_JITTER, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final SSLConfigurationSettings ELASTIC_INFERENCE_SERVICE_SSL_CONFIGURATION_SETTINGS = SSLConfigurationSettings.withPrefix((String)"xpack.inference.elastic.http.ssl.", (boolean)false);
    public static final Setting<Boolean> ELASTIC_INFERENCE_SERVICE_SSL_ENABLED = Setting.boolSetting((String)"xpack.inference.elastic.http.ssl.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CONNECTION_TTL_SETTING = Setting.timeSetting((String)"xpack.inference.elastic.http.connection_ttl", (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    @Deprecated
    private final String eisGatewayUrl;
    private final String elasticInferenceServiceUrl;
    private final boolean periodicAuthorizationEnabled;
    private volatile TimeValue authRequestInterval;
    private volatile TimeValue maxAuthorizationRequestJitter;
    private final TimeValue connectionTtl;

    public ElasticInferenceServiceSettings(Settings settings) {
        this.eisGatewayUrl = (String)EIS_GATEWAY_URL.get(settings);
        this.elasticInferenceServiceUrl = (String)ELASTIC_INFERENCE_SERVICE_URL.get(settings);
        this.periodicAuthorizationEnabled = (Boolean)PERIODIC_AUTHORIZATION_ENABLED.get(settings);
        this.authRequestInterval = (TimeValue)AUTHORIZATION_REQUEST_INTERVAL.get(settings);
        this.maxAuthorizationRequestJitter = (TimeValue)MAX_AUTHORIZATION_REQUEST_JITTER.get(settings);
        this.connectionTtl = (TimeValue)CONNECTION_TTL_SETTING.get(settings);
    }

    public final void init(ClusterService clusterService) {
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AUTHORIZATION_REQUEST_INTERVAL, this::setAuthorizationRequestInterval);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_AUTHORIZATION_REQUEST_JITTER, this::setMaxAuthorizationRequestJitter);
    }

    private void setAuthorizationRequestInterval(TimeValue interval) {
        this.authRequestInterval = interval;
    }

    private void setMaxAuthorizationRequestJitter(TimeValue jitter) {
        this.maxAuthorizationRequestJitter = jitter;
    }

    public TimeValue getAuthRequestInterval() {
        return this.authRequestInterval;
    }

    public TimeValue getMaxAuthorizationRequestJitter() {
        return this.maxAuthorizationRequestJitter;
    }

    public TimeValue getConnectionTtl() {
        return this.connectionTtl;
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        ArrayList settings = new ArrayList();
        settings.add(EIS_GATEWAY_URL);
        settings.add(ELASTIC_INFERENCE_SERVICE_URL);
        settings.add(ELASTIC_INFERENCE_SERVICE_SSL_ENABLED);
        settings.addAll(ELASTIC_INFERENCE_SERVICE_SSL_CONFIGURATION_SETTINGS.getEnabledSettings());
        settings.add(PERIODIC_AUTHORIZATION_ENABLED);
        settings.add(AUTHORIZATION_REQUEST_INTERVAL);
        settings.add(MAX_AUTHORIZATION_REQUEST_JITTER);
        settings.add(CONNECTION_TTL_SETTING);
        return settings;
    }

    public String getElasticInferenceServiceUrl() {
        return Strings.isEmpty((CharSequence)this.elasticInferenceServiceUrl) ? this.eisGatewayUrl : this.elasticInferenceServiceUrl;
    }

    public boolean isPeriodicAuthorizationEnabled() {
        return this.periodicAuthorizationEnabled;
    }
}

