/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.request;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.inference.common.JsonUtils;
import org.elasticsearch.xpack.inference.common.ValidatingSubstitutor;
import org.elasticsearch.xpack.inference.external.request.HttpRequest;
import org.elasticsearch.xpack.inference.external.request.Request;
import org.elasticsearch.xpack.inference.services.custom.CustomModel;
import org.elasticsearch.xpack.inference.services.custom.CustomServiceSettings;
import org.elasticsearch.xpack.inference.services.custom.QueryParameters;
import org.elasticsearch.xpack.inference.services.custom.request.RequestParameters;

public class CustomRequest
implements Request {
    private final URI uri;
    private final ValidatingSubstitutor jsonPlaceholderReplacer;
    private final ValidatingSubstitutor stringPlaceholderReplacer;
    private final CustomModel model;

    public CustomRequest(RequestParameters requestParams, CustomModel model) {
        this.model = Objects.requireNonNull(model);
        HashMap<String, String> stringOnlyParams = new HashMap<String, String>();
        CustomRequest.addStringParams(stringOnlyParams, model.getSecretSettings().getSecretParameters());
        CustomRequest.addStringParams(stringOnlyParams, model.getTaskSettings().getParameters());
        HashMap<String, String> jsonParams = new HashMap<String, String>();
        CustomRequest.addJsonStringParams(jsonParams, model.getSecretSettings().getSecretParameters());
        CustomRequest.addJsonStringParams(jsonParams, model.getTaskSettings().getParameters());
        jsonParams.putAll(requestParams.jsonParameters());
        this.jsonPlaceholderReplacer = new ValidatingSubstitutor(jsonParams, "${", "}");
        this.stringPlaceholderReplacer = new ValidatingSubstitutor(stringOnlyParams, "${", "}");
        this.uri = this.buildUri();
    }

    private static void addStringParams(Map<String, String> stringParams, Map<String, ?> paramsToAdd) {
        for (Map.Entry<String, ?> entry : paramsToAdd.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof String) {
                String str = (String)obj;
                stringParams.put(entry.getKey(), str);
                continue;
            }
            obj = entry.getValue();
            if (!(obj instanceof SecureString)) continue;
            SecureString secureString = (SecureString)obj;
            stringParams.put(entry.getKey(), secureString.toString());
        }
    }

    private static void addJsonStringParams(Map<String, String> jsonStringParams, Map<String, ?> params) {
        for (Map.Entry<String, ?> entry : params.entrySet()) {
            jsonStringParams.put(entry.getKey(), JsonUtils.toJson(entry.getValue(), entry.getKey()));
        }
    }

    private URI buildUri() {
        String replacedUrl = this.stringPlaceholderReplacer.replace(this.model.getServiceSettings().getUrl(), "url");
        try {
            URIBuilder builder = new URIBuilder(replacedUrl);
            for (QueryParameters.Parameter queryParam : this.model.getServiceSettings().getQueryParameters().parameters()) {
                builder.addParameter(queryParam.key(), this.stringPlaceholderReplacer.replace(queryParam.value(), Strings.format((String)"query parameters: [%s]", (Object[])new Object[]{queryParam.key()})));
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(Strings.format((String)"Failed to build URI, error: %s", (Object[])new Object[]{e.getMessage()}), e);
        }
    }

    @Override
    public HttpRequest createHttpRequest() {
        HttpPost httpRequest = new HttpPost(this.uri);
        this.setHeaders((HttpRequestBase)httpRequest);
        this.setRequestContent(httpRequest);
        return new HttpRequest((HttpRequestBase)httpRequest, this.getInferenceEntityId());
    }

    private void setHeaders(HttpRequestBase httpRequest) {
        httpRequest.setHeader("Content-Type", XContentType.JSON.mediaType());
        for (Map.Entry<String, String> entry : this.model.getServiceSettings().getHeaders().entrySet()) {
            String replacedHeadersValue = this.stringPlaceholderReplacer.replace(entry.getValue(), Strings.format((String)"header.%s", (Object[])new Object[]{entry.getKey()}));
            httpRequest.setHeader(entry.getKey(), replacedHeadersValue);
        }
    }

    private void setRequestContent(HttpPost httpRequest) {
        String replacedRequestContentString = this.jsonPlaceholderReplacer.replace(this.model.getServiceSettings().getRequestContentString(), "request");
        StringEntity stringEntity = new StringEntity(replacedRequestContentString, StandardCharsets.UTF_8);
        httpRequest.setEntity((HttpEntity)stringEntity);
    }

    @Override
    public String getInferenceEntityId() {
        return this.model.getInferenceEntityId();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public CustomServiceSettings getServiceSettings() {
        return this.model.getServiceSettings();
    }

    @Override
    public Request truncate() {
        return this;
    }

    @Override
    public boolean[] getTruncationInfo() {
        return null;
    }
}

