/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom;

import java.util.Locale;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;

public enum CustomServiceEmbeddingType {
    FLOAT(DenseVectorFieldMapper.ElementType.FLOAT),
    BYTE(DenseVectorFieldMapper.ElementType.BYTE),
    BIT(DenseVectorFieldMapper.ElementType.BIT),
    BINARY(DenseVectorFieldMapper.ElementType.BIT);

    private final DenseVectorFieldMapper.ElementType elementType;

    private CustomServiceEmbeddingType(DenseVectorFieldMapper.ElementType elementType) {
        this.elementType = elementType;
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public DenseVectorFieldMapper.ElementType toElementType() {
        return this.elementType;
    }

    public static CustomServiceEmbeddingType fromString(String name) {
        return CustomServiceEmbeddingType.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }
}

