/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai.rerank;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.TaskSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class ContextualAiRerankTaskSettings
implements TaskSettings {
    public static final String NAME = "contextualai_rerank_task_settings";
    public static final String RETURN_DOCUMENTS = "return_documents";
    public static final String TOP_N_DOCS_ONLY = "top_n";
    public static final String INSTRUCTION = "instruction";
    private static final String DEFAULT_INSTRUCTION = "Rerank the given documents based on their relevance to the query.";
    public static final ContextualAiRerankTaskSettings EMPTY_SETTINGS = new ContextualAiRerankTaskSettings(null, null, null);
    private final Boolean returnDocuments;
    private final Integer topN;
    private final String instruction;

    public static ContextualAiRerankTaskSettings fromMap(Map<String, Object> map) {
        ValidationException validationException = new ValidationException();
        if (map == null || map.isEmpty()) {
            return EMPTY_SETTINGS;
        }
        Boolean returnDocuments = ServiceUtils.extractOptionalBoolean(map, RETURN_DOCUMENTS, validationException);
        Integer topN = ServiceUtils.extractOptionalPositiveInteger(map, TOP_N_DOCS_ONLY, "task_settings", validationException);
        String instruction = ServiceUtils.extractOptionalString(map, INSTRUCTION, "task_settings", validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new ContextualAiRerankTaskSettings(returnDocuments, topN, instruction);
    }

    public static ContextualAiRerankTaskSettings of(ContextualAiRerankTaskSettings originalSettings, ContextualAiRerankTaskSettings requestSettings) {
        Boolean returnDocuments = requestSettings.getReturnDocuments() != null ? requestSettings.getReturnDocuments() : originalSettings.getReturnDocuments();
        Integer topN = requestSettings.getTopN() != null ? requestSettings.getTopN() : originalSettings.getTopN();
        String instruction = requestSettings.getInstruction() != null ? requestSettings.getInstruction() : originalSettings.getInstruction();
        return new ContextualAiRerankTaskSettings(returnDocuments, topN, instruction);
    }

    public ContextualAiRerankTaskSettings(@Nullable Boolean returnDocuments, @Nullable Integer topN, @Nullable String instruction) {
        this.returnDocuments = returnDocuments;
        this.topN = topN;
        this.instruction = instruction;
    }

    public ContextualAiRerankTaskSettings(StreamInput in) throws IOException {
        this.returnDocuments = in.readOptionalBoolean();
        this.topN = in.readOptionalVInt();
        this.instruction = in.readOptionalString();
    }

    @Nullable
    public Boolean getReturnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public Integer getTopN() {
        return this.topN;
    }

    public String getInstruction() {
        return this.instruction != null ? this.instruction : DEFAULT_INSTRUCTION;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalBoolean(this.returnDocuments);
        out.writeOptionalVInt(this.topN);
        out.writeOptionalString(this.instruction);
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.returnDocuments != null) {
            builder.field(RETURN_DOCUMENTS, this.returnDocuments);
        }
        if (this.topN != null) {
            builder.field(TOP_N_DOCS_ONLY, this.topN);
        }
        if (this.instruction != null) {
            builder.field(INSTRUCTION, this.instruction);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContextualAiRerankTaskSettings that = (ContextualAiRerankTaskSettings)object;
        return Objects.equals(this.returnDocuments, that.returnDocuments) && Objects.equals(this.topN, that.topN) && Objects.equals(this.instruction, that.instruction);
    }

    public int hashCode() {
        return Objects.hash(this.returnDocuments, this.topN, this.instruction);
    }

    public TaskSettings updatedTaskSettings(Map<String, Object> newSettings) {
        return ContextualAiRerankTaskSettings.fromMap(newSettings);
    }

    public boolean isEmpty() {
        return this.returnDocuments == null && this.topN == null && this.instruction == null;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }
}

