/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rest;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceEndpointAction;

@ServerlessScope(value=Scope.PUBLIC)
public class RestDeleteInferenceEndpointAction
extends BaseRestHandler {
    private static final String FORCE_DELETE_NAME = "force";
    private static final String DRY_RUN_NAME = "dry_run";

    public String getName() {
        return "delete_inference_model_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "_inference/{task_type_or_id}"), new RestHandler.Route(RestRequest.Method.DELETE, "_inference/{task_type_or_id}/{inference_id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) {
        TaskType taskType;
        String inferenceEntityId;
        boolean forceDelete = false;
        boolean dryRun = false;
        if (restRequest.hasParam("inference_id")) {
            inferenceEntityId = restRequest.param("inference_id");
            taskType = TaskType.fromStringOrStatusException((String)restRequest.param("task_type_or_id"));
        } else {
            inferenceEntityId = restRequest.param("task_type_or_id");
            taskType = TaskType.ANY;
        }
        forceDelete = restRequest.paramAsBoolean(FORCE_DELETE_NAME, false);
        dryRun = restRequest.paramAsBoolean(DRY_RUN_NAME, false);
        DeleteInferenceEndpointAction.Request request = new DeleteInferenceEndpointAction.Request(inferenceEntityId, taskType, forceDelete, dryRun);
        return channel -> client.execute((ActionType)DeleteInferenceEndpointAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

