/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.streaming;

import java.util.Deque;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEvent;
import org.elasticsearch.xpack.inference.external.response.streaming.ServerSentEventParser;

public class ServerSentEventProcessor
extends DelegatingProcessor<HttpResult, Deque<ServerSentEvent>> {
    private final ServerSentEventParser serverSentEventParser;

    public ServerSentEventProcessor(ServerSentEventParser serverSentEventParser) {
        this.serverSentEventParser = serverSentEventParser;
    }

    @Override
    public void next(HttpResult item) {
        if (item.isBodyEmpty()) {
            this.upstream().request(1L);
            return;
        }
        Deque<ServerSentEvent> response = this.serverSentEventParser.parse(item.body());
        if (response.isEmpty()) {
            this.upstream().request(1L);
            return;
        }
        this.downstream().onNext(response);
    }
}

