/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.retry.ErrorResponse;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorParserContract;
import org.elasticsearch.xpack.inference.external.http.retry.UnifiedChatCompletionErrorResponseUtils;

public class UnifiedChatCompletionErrorResponse
extends ErrorResponse {
    static final ConstructingObjectParser<Optional<UnifiedChatCompletionErrorResponse>, Void> ERROR_OBJECT_PARSER = new ConstructingObjectParser("streaming_error", true, args -> Optional.ofNullable((UnifiedChatCompletionErrorResponse)args[0]));
    private static final ConstructingObjectParser<UnifiedChatCompletionErrorResponse, Void> ERROR_BODY_PARSER = new ConstructingObjectParser("streaming_error", true, args -> new UnifiedChatCompletionErrorResponse((String)args[0], (String)args[1], (String)args[2], (String)args[3]));
    public static final UnifiedChatCompletionErrorParserContract ERROR_PARSER;
    public static final UnifiedChatCompletionErrorResponse UNDEFINED_ERROR;
    @Nullable
    private final String code;
    @Nullable
    private final String param;
    private final String type;

    public static UnifiedChatCompletionErrorResponse fromHttpResult(HttpResult response) {
        return ERROR_PARSER.parse(response);
    }

    public UnifiedChatCompletionErrorResponse(String errorMessage, String type, @Nullable String code, @Nullable String param) {
        super(errorMessage);
        this.code = code;
        this.param = param;
        this.type = Objects.requireNonNull(type);
    }

    private UnifiedChatCompletionErrorResponse() {
        super(false);
        this.code = null;
        this.param = null;
        this.type = "unknown";
    }

    @Nullable
    public String code() {
        return this.code;
    }

    @Nullable
    public String param() {
        return this.param;
    }

    public String type() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnifiedChatCompletionErrorResponse that = (UnifiedChatCompletionErrorResponse)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.param, that.param) && Objects.equals(this.type, that.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.code, this.param, this.type);
    }

    static {
        ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("message", new String[0]));
        ERROR_BODY_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("code", new String[0]));
        ERROR_BODY_PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), new ParseField("param", new String[0]));
        ERROR_OBJECT_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), ERROR_BODY_PARSER, null, new ParseField("error", new String[0]));
        ERROR_PARSER = UnifiedChatCompletionErrorResponseUtils.createErrorParserWithObjectParser(ERROR_OBJECT_PARSER);
        UNDEFINED_ERROR = new UnifiedChatCompletionErrorResponse();
    }
}

