/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringSubstitutor;
import org.elasticsearch.common.Strings;

public class ValidatingSubstitutor {
    private static final Pattern VARIABLE_PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{.*?\\}");
    private final StringSubstitutor substitutor;

    public ValidatingSubstitutor(Map<String, String> params, String prefix, String suffix) {
        this.substitutor = new StringSubstitutor(params, prefix, suffix);
    }

    public String replace(String source, String field) {
        String replacedString = this.substitutor.replace(source);
        ValidatingSubstitutor.ensureNoMorePlaceholdersExist(replacedString, field);
        return replacedString;
    }

    private static void ensureNoMorePlaceholdersExist(String substitutedString, String field) {
        Matcher matcher = VARIABLE_PLACEHOLDER_PATTERN.matcher(substitutedString);
        if (matcher.find()) {
            throw new IllegalStateException(Strings.format((String)"Found placeholder [%s] in field [%s] after replacement call, please check that all templates have a corresponding field definition.", (Object[])new Object[]{matcher.group(), field}));
        }
    }
}

