/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceService;
import org.elasticsearch.inference.InferenceServiceConfiguration;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.inference.action.GetInferenceServicesAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.elastic.ElasticInferenceService;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationModel;
import org.elasticsearch.xpack.inference.services.elastic.authorization.ElasticInferenceServiceAuthorizationRequestHandler;

public class TransportGetInferenceServicesAction
extends HandledTransportAction<GetInferenceServicesAction.Request, GetInferenceServicesAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetInferenceServicesAction.class);
    private final InferenceServiceRegistry serviceRegistry;
    private final ElasticInferenceServiceAuthorizationRequestHandler eisAuthorizationRequestHandler;
    private final Sender eisSender;
    private final ThreadPool threadPool;

    @Inject
    public TransportGetInferenceServicesAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, InferenceServiceRegistry serviceRegistry, ElasticInferenceServiceAuthorizationRequestHandler eisAuthorizationRequestHandler, Sender sender) {
        super("cluster:monitor/xpack/inference/services/get", transportService, actionFilters, GetInferenceServicesAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.serviceRegistry = serviceRegistry;
        this.eisAuthorizationRequestHandler = eisAuthorizationRequestHandler;
        this.eisSender = sender;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, GetInferenceServicesAction.Request request, ActionListener<GetInferenceServicesAction.Response> listener) {
        if (request.getTaskType() == TaskType.ANY) {
            this.getAllServiceConfigurations(listener);
        } else {
            this.getServiceConfigurationsForTaskType(request.getTaskType(), listener);
        }
    }

    private void getServiceConfigurationsForTaskType(TaskType requestedTaskType, ActionListener<GetInferenceServicesAction.Response> listener) {
        ArrayList filteredServices = this.serviceRegistry.getServices().entrySet().stream().filter(service -> !((InferenceService)service.getValue()).name().equals("elastic") && !((InferenceService)service.getValue()).hideFromConfigurationApi() && ((InferenceService)service.getValue()).supportedTaskTypes().contains(requestedTaskType)).sorted(Comparator.comparing(service -> ((InferenceService)service.getValue()).name())).collect(Collectors.toCollection(ArrayList::new));
        this.getServiceConfigurationsForServicesAndEis(listener, filteredServices, requestedTaskType);
    }

    private void getAllServiceConfigurations(ActionListener<GetInferenceServicesAction.Response> listener) {
        ArrayList availableServices = this.serviceRegistry.getServices().entrySet().stream().filter(service -> !((InferenceService)service.getValue()).name().equals("elastic") && !((InferenceService)service.getValue()).hideFromConfigurationApi()).sorted(Comparator.comparing(service -> ((InferenceService)service.getValue()).name())).collect(Collectors.toCollection(ArrayList::new));
        this.getServiceConfigurationsForServicesAndEis(listener, availableServices, null);
    }

    private void getServiceConfigurationsForServicesAndEis(ActionListener<GetInferenceServicesAction.Response> listener, ArrayList<Map.Entry<String, InferenceService>> availableServices, @Nullable TaskType requestedTaskType) {
        SubscribableListener.newForked(authModelListener -> this.threadPool.executor("inference_utility").execute(() -> this.getEisAuthorization((ActionListener<ElasticInferenceServiceAuthorizationModel>)authModelListener, this.eisSender))).andThen((configurationListener, authorizationModel) -> {
            List<InferenceServiceConfiguration> serviceConfigs = this.getServiceConfigurationsForServices(availableServices);
            if (!authorizationModel.isAuthorized()) {
                configurationListener.onResponse(serviceConfigs);
                return;
            }
            InferenceServiceConfiguration config = ElasticInferenceService.createConfiguration(authorizationModel.getAuthorizedTaskTypes());
            if (requestedTaskType != null && !authorizationModel.getAuthorizedTaskTypes().contains(requestedTaskType)) {
                configurationListener.onResponse(serviceConfigs);
                return;
            }
            serviceConfigs.add(config);
            serviceConfigs.sort(Comparator.comparing(InferenceServiceConfiguration::getService));
            configurationListener.onResponse(serviceConfigs);
        }).addListener(listener.delegateFailureAndWrap((delegate, configurations) -> delegate.onResponse((Object)new GetInferenceServicesAction.Response(configurations))));
    }

    private void getEisAuthorization(ActionListener<ElasticInferenceServiceAuthorizationModel> listener, Sender sender) {
        ActionListener disabledServiceListener = listener.delegateResponse((delegate, e) -> {
            logger.warn("Failed to retrieve authorization information from the Elastic Inference Service while determining service configurations. Marking service as disabled.", (Throwable)e);
            delegate.onResponse((Object)ElasticInferenceServiceAuthorizationModel.newDisabledService());
        });
        this.eisAuthorizationRequestHandler.getAuthorization((ActionListener<ElasticInferenceServiceAuthorizationModel>)disabledServiceListener, sender);
    }

    private List<InferenceServiceConfiguration> getServiceConfigurationsForServices(ArrayList<Map.Entry<String, InferenceService>> services) {
        ArrayList<InferenceServiceConfiguration> serviceConfigurations = new ArrayList<InferenceServiceConfiguration>();
        for (Map.Entry<String, InferenceService> service : services) {
            serviceConfigurations.add(service.getValue().getConfiguration());
        }
        return serviceConfigurations;
    }
}

