/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.time.Clock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.transport.LinkedProjectConfigService;
import org.elasticsearch.xpack.core.transform.transforms.TimeSyncConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpointingInfo;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointException;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.DefaultCheckpointProvider;
import org.elasticsearch.xpack.transform.checkpoint.RemoteClusterResolver;
import org.elasticsearch.xpack.transform.checkpoint.TimeBasedCheckpointProvider;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;

public class TransformCheckpointService {
    private static final Logger logger = LogManager.getLogger(TransformCheckpointService.class);
    private final Clock clock;
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor transformAuditor;
    private final RemoteClusterResolver remoteClusterResolver;

    public TransformCheckpointService(Clock clock, Settings settings, LinkedProjectConfigService linkedProjectConfigService, TransformConfigManager transformConfigManager, TransformAuditor transformAuditor) {
        this.clock = clock;
        this.transformConfigManager = transformConfigManager;
        this.transformAuditor = transformAuditor;
        this.remoteClusterResolver = new RemoteClusterResolver(settings, linkedProjectConfigService);
    }

    public CheckpointProvider getCheckpointProvider(ParentTaskAssigningClient client, TransformConfig transformConfig) {
        if (transformConfig.getSyncConfig() instanceof TimeSyncConfig) {
            return new TimeBasedCheckpointProvider(this.clock, client, this.remoteClusterResolver, this.transformConfigManager, this.transformAuditor, transformConfig);
        }
        return new DefaultCheckpointProvider(this.clock, client, this.remoteClusterResolver, this.transformConfigManager, this.transformAuditor, transformConfig);
    }

    public void getCheckpointingInfo(ParentTaskAssigningClient client, TimeValue timeout, String transformId, long lastCheckpointNumber, TransformIndexerPosition nextCheckpointPosition, TransformProgress nextCheckpointProgress, ActionListener<TransformCheckpointingInfo.TransformCheckpointingInfoBuilder> listener) {
        this.transformConfigManager.getTransformConfiguration(transformId, (ActionListener<TransformConfig>)ActionListener.wrap(transformConfig -> this.getCheckpointProvider(client, (TransformConfig)transformConfig).getCheckpointingInfo(lastCheckpointNumber, nextCheckpointPosition, nextCheckpointProgress, timeout, listener), transformError -> {
            logger.warn("Failed to retrieve configuration for transform [" + transformId + "]", (Throwable)transformError);
            listener.onFailure((Exception)((Object)new CheckpointException("Failed to retrieve configuration", (Throwable)transformError, new Object[0])));
        }));
    }

    public static TransformCheckpointingInfo deriveBasicCheckpointingInfo(TransformState transformState) {
        return new TransformCheckpointingInfo(TransformCheckpointService.lastCheckpointStats(transformState), TransformCheckpointService.nextCheckpointStats(transformState), 0L, null, null);
    }

    private static TransformCheckpointStats lastCheckpointStats(TransformState transformState) {
        return new TransformCheckpointStats(transformState.getCheckpoint(), null, null, 0L, 0L);
    }

    private static TransformCheckpointStats nextCheckpointStats(TransformState transformState) {
        long checkpoint = transformState.getCheckpoint() != 0L ? transformState.getCheckpoint() + 1L : 0L;
        return new TransformCheckpointStats(checkpoint, transformState.getPosition(), transformState.getProgress(), 0L, 0L);
    }
}

