/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.policy;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class AutoscalingPolicy
implements SimpleDiffable<AutoscalingPolicy>,
ToXContentObject {
    public static final String NAME = "autoscaling_policy";
    public static final ParseField ROLES_FIELD = new ParseField("roles", new String[0]);
    public static final ParseField DECIDERS_FIELD = new ParseField("deciders", new String[0]);
    private static final ConstructingObjectParser<AutoscalingPolicy, String> PARSER = new ConstructingObjectParser("autoscaling_policy", false, (c, name) -> {
        List roles = (List)c[0];
        List deciders = (List)c[1];
        return new AutoscalingPolicy((String)name, (SortedSet)roles.stream().collect(Sets.toUnmodifiableSortedSet()), (SortedMap)deciders.stream().collect(Maps.toUnmodifiableSortedMap(Map.Entry::getKey, Map.Entry::getValue)));
    });
    private final String name;
    private final SortedSet<String> roles;
    private final SortedMap<String, Settings> deciders;

    public static AutoscalingPolicy parse(XContentParser parser, String name) {
        return (AutoscalingPolicy)PARSER.apply(parser, (Object)name);
    }

    public String name() {
        return this.name;
    }

    public SortedSet<String> roles() {
        return this.roles;
    }

    public SortedMap<String, Settings> deciders() {
        return this.deciders;
    }

    public AutoscalingPolicy(String name, SortedSet<String> roles, SortedMap<String, Settings> deciders) {
        this.name = Objects.requireNonNull(name);
        this.roles = Objects.requireNonNull(roles);
        this.deciders = Objects.requireNonNull(deciders);
    }

    public AutoscalingPolicy(StreamInput in) throws IOException {
        this.name = in.readString();
        this.roles = (SortedSet)in.readCollectionAsSet(StreamInput::readString).stream().collect(Sets.toUnmodifiableSortedSet());
        int deciderCount = in.readInt();
        TreeMap<String, Settings> decidersMap = new TreeMap<String, Settings>();
        for (int i = 0; i < deciderCount; ++i) {
            decidersMap.put(in.readString(), Settings.readSettingsFromStream((StreamInput)in));
        }
        this.deciders = Collections.unmodifiableSortedMap(decidersMap);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringCollection(this.roles);
        out.writeInt(this.deciders.size());
        for (Map.Entry<String, Settings> entry : this.deciders.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.array(ROLES_FIELD.getPreferredName(), (String[])this.roles.toArray(String[]::new));
        builder.startObject(DECIDERS_FIELD.getPreferredName());
        for (Map.Entry<String, Settings> entry : this.deciders.entrySet()) {
            builder.startObject(entry.getKey());
            entry.getValue().toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoscalingPolicy that = (AutoscalingPolicy)o;
        return this.name.equals(that.name) && this.roles.equals(that.roles) && this.deciders.equals(that.deciders);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.roles, this.deciders);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), ROLES_FIELD);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            p.nextToken();
            return new AbstractMap.SimpleEntry<String, Settings>(n, Settings.fromXContent((XContentParser)p));
        }, DECIDERS_FIELD);
    }
}

