/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.support;

import java.io.IOException;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.index.fielddata.DocValueBits;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.index.fielddata.LeafHistogramFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.AggregationErrors;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class HistogramValuesSource {

    public static abstract class Histogram
    extends ValuesSource {
        public abstract HistogramValues getHistogramValues(LeafReaderContext var1) throws IOException;

        public Function<Rounding, Rounding.Prepared> roundingPreparer(AggregationContext context) throws IOException {
            throw AggregationErrors.unsupportedRounding((String)"histogram");
        }

        public static class Fielddata
        extends Histogram {
            protected final IndexHistogramFieldData indexFieldData;

            public Fielddata(IndexHistogramFieldData indexFieldData) {
                this.indexFieldData = indexFieldData;
            }

            public SortedBinaryDocValues bytesValues(LeafReaderContext context) {
                return ((LeafHistogramFieldData)this.indexFieldData.load(context)).getBytesValues();
            }

            public DocValueBits docsWithValue(LeafReaderContext context) throws IOException {
                final HistogramValues values = this.getHistogramValues(context);
                return new DocValueBits(this){

                    public boolean advanceExact(int doc) throws IOException {
                        return values.advanceExact(doc);
                    }
                };
            }

            @Override
            public HistogramValues getHistogramValues(LeafReaderContext context) throws IOException {
                return ((LeafHistogramFieldData)this.indexFieldData.load(context)).getHistogramValues();
            }
        }
    }
}

