/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.AbstractTransportRequest;
import org.elasticsearch.transport.BytesTransportMessage;

public class BytesTransportRequest
extends AbstractTransportRequest
implements BytesTransportMessage {
    final ReleasableBytesReference bytes;
    private final TransportVersion version;

    public BytesTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.bytes = in.readReleasableBytesReference();
        this.version = in.getTransportVersion();
    }

    public BytesTransportRequest(ReleasableBytesReference bytes, TransportVersion version) {
        this.bytes = bytes;
        this.version = version;
    }

    public TransportVersion version() {
        return this.version;
    }

    @Override
    public ReleasableBytesReference bytes() {
        return this.bytes;
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.bytes.length());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.bytes);
    }

    @Override
    public void incRef() {
        this.bytes.incRef();
    }

    @Override
    public boolean tryIncRef() {
        return this.bytes.tryIncRef();
    }

    @Override
    public boolean decRef() {
        return this.bytes.decRef();
    }

    @Override
    public boolean hasReferences() {
        return this.bytes.hasReferences();
    }
}

