/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RescoreVectorBuilder
implements Writeable,
ToXContentObject {
    public static final ParseField OVERSAMPLE_FIELD = new ParseField("oversample", new String[0]);
    public static final float NO_OVERSAMPLE = 0.0f;
    public static final float MIN_OVERSAMPLE = 1.0f;
    private static final ConstructingObjectParser<RescoreVectorBuilder, Void> PARSER = new ConstructingObjectParser("rescore_vector", args -> new RescoreVectorBuilder(((Float)args[0]).floatValue()));
    private static final TransportVersion RESCORE_VECTOR_ALLOW_ZERO;
    private final float oversample;

    public RescoreVectorBuilder(float numCandidatesFactor) {
        Objects.requireNonNull(Float.valueOf(numCandidatesFactor), "[" + OVERSAMPLE_FIELD.getPreferredName() + "] must be set");
        if (numCandidatesFactor < 1.0f && numCandidatesFactor != 0.0f) {
            throw new IllegalArgumentException("[" + OVERSAMPLE_FIELD.getPreferredName() + "] must be >= 1.0 or 0");
        }
        this.oversample = numCandidatesFactor;
    }

    public RescoreVectorBuilder(StreamInput in) throws IOException {
        this.oversample = in.readFloat();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.oversample == 0.0f && !out.getTransportVersion().supports(RESCORE_VECTOR_ALLOW_ZERO)) {
            throw new ElasticsearchStatusException("[rescore_vector] does not support a 0 for [" + OVERSAMPLE_FIELD.getPreferredName() + "] before version [" + RESCORE_VECTOR_ALLOW_ZERO.toReleaseVersion() + "]", RestStatus.BAD_REQUEST, new Object[0]);
        }
        out.writeFloat(this.oversample);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(OVERSAMPLE_FIELD.getPreferredName(), this.oversample);
        builder.endObject();
        return builder;
    }

    public static RescoreVectorBuilder fromXContent(XContentParser parser) {
        return (RescoreVectorBuilder)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RescoreVectorBuilder that = (RescoreVectorBuilder)o;
        return Objects.equals(Float.valueOf(this.oversample), Float.valueOf(that.oversample));
    }

    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.oversample));
    }

    public float oversample() {
        return this.oversample;
    }

    static {
        PARSER.declareFloat(ConstructingObjectParser.constructorArg(), OVERSAMPLE_FIELD);
        RESCORE_VECTOR_ALLOW_ZERO = TransportVersion.fromName("rescore_vector_allow_zero");
    }
}

