/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.rescore;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.rescore.Rescorer;

public class RescoreContext {
    private final int windowSize;
    private final Rescorer rescorer;
    private Set<Integer> rescoredDocs;
    private Runnable isCancelled;

    public RescoreContext(int windowSize, Rescorer rescorer) {
        this.windowSize = windowSize;
        this.rescorer = rescorer;
    }

    public void setCancellationChecker(Runnable isCancelled) {
        this.isCancelled = isCancelled;
    }

    public void checkCancellation() {
        if (this.isCancelled != null) {
            this.isCancelled.run();
        }
    }

    public Rescorer rescorer() {
        return this.rescorer;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setRescoredDocs(Set<Integer> docIds) {
        this.rescoredDocs = docIds;
    }

    public boolean isRescored(int docId) {
        return this.rescoredDocs != null && this.rescoredDocs.contains(docId);
    }

    public Set<Integer> getRescoredDocs() {
        return this.rescoredDocs;
    }

    public List<ParsedQuery> getParsedQueries() {
        return Collections.emptyList();
    }
}

