/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQuery;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RandomSamplingQueryBuilder
extends AbstractQueryBuilder<RandomSamplingQueryBuilder> {
    public static final String NAME = "random_sampling";
    static final ParseField PROBABILITY = new ParseField("query", new String[0]);
    static final ParseField SEED = new ParseField("seed", new String[0]);
    static final ParseField HASH = new ParseField("hash", new String[0]);
    private static final TransportVersion RANDOM_SAMPLER_QUERY_BUILDER = TransportVersion.fromName("random_sampler_query_builder");
    private final double probability;
    private int seed = Randomness.get().nextInt();
    private int hash = 0;
    private static final ConstructingObjectParser<RandomSamplingQueryBuilder, Void> PARSER = new ConstructingObjectParser("random_sampling", false, args -> {
        RandomSamplingQueryBuilder randomSamplingQueryBuilder = new RandomSamplingQueryBuilder((Double)args[0]);
        if (args[1] != null) {
            randomSamplingQueryBuilder.seed((Integer)args[1]);
        }
        if (args[2] != null) {
            randomSamplingQueryBuilder.hash((int)((Integer)args[2]));
        }
        return randomSamplingQueryBuilder;
    });

    public RandomSamplingQueryBuilder(double probability) {
        RandomSamplingQuery.checkProbabilityRange(probability);
        this.probability = probability;
    }

    public RandomSamplingQueryBuilder seed(int seed) {
        RandomSamplingQuery.checkProbabilityRange(this.probability);
        this.seed = seed;
        return this;
    }

    public RandomSamplingQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.probability = in.readDouble();
        this.seed = in.readInt();
        this.hash = in.readInt();
    }

    public RandomSamplingQueryBuilder hash(Integer hash) {
        this.hash = hash;
        return this;
    }

    public double probability() {
        return this.probability;
    }

    public int seed() {
        return this.seed;
    }

    public int hash() {
        return this.hash;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeDouble(this.probability);
        out.writeInt(this.seed);
        out.writeInt(this.hash);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        builder.field(SEED.getPreferredName(), this.seed);
        builder.field(HASH.getPreferredName(), this.hash);
        builder.endObject();
    }

    public static RandomSamplingQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return (RandomSamplingQueryBuilder)PARSER.apply(parser, null);
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        return new RandomSamplingQuery(this.probability, this.seed, this.hash);
    }

    @Override
    protected boolean doEquals(RandomSamplingQueryBuilder other) {
        return this.probability == other.probability && this.seed == other.seed && this.hash == other.hash;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.probability, this.seed, this.hash);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public boolean supportsVersion(TransportVersion version) {
        return version.supports(RANDOM_SAMPLER_QUERY_BUILDER);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        assert (false) : "must not be called when overriding supportsVersion";
        throw new UnsupportedOperationException("must not be called when overriding supportsVersion");
    }

    static {
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), PROBABILITY);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), SEED);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), HASH);
    }
}

