/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.random.InternalRandomSampler;
import org.elasticsearch.search.aggregations.bucket.sampler.random.RandomSamplingQuery;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class RandomSamplerAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    private final int seed;
    private final Integer shardSeed;
    private final double probability;
    private Weight weight;

    RandomSamplerAggregator(String name, int seed, Integer shardSeed, double probability, AggregatorFactories factories, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinalityUpperBound, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinalityUpperBound, metadata);
        this.seed = seed;
        this.probability = probability;
        if (this.subAggregators().length == 0) {
            throw new IllegalArgumentException("random_sampler aggregation [" + name + "] must have sub aggregations configured");
        }
        this.shardSeed = shardSeed;
    }

    private Weight getWeight() throws IOException {
        if (this.weight == null) {
            ScoreMode scoreMode = this.scoreMode();
            BooleanQuery.Builder fullQuery = new BooleanQuery.Builder().add(this.context.query(), scoreMode.needsScores() ? BooleanClause.Occur.MUST : BooleanClause.Occur.FILTER);
            if (this.probability < 1.0) {
                RandomSamplingQuery sampleQuery = new RandomSamplingQuery(this.probability, this.seed, this.shardSeed == null ? this.context.shardRandomSeed() : this.shardSeed.intValue());
                fullQuery.add((Query)sampleQuery, BooleanClause.Occur.FILTER);
            }
            this.weight = this.context.searcher().createWeight(this.context.searcher().rewrite((Query)fullQuery.build()), scoreMode, 1.0f);
        }
        return this.weight;
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalRandomSampler(this.name, this.bucketDocCount(owningBucketOrd), this.seed, this.shardSeed, this.probability, subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalRandomSampler(this.name, 0L, this.seed, this.shardSeed, this.probability, this.buildEmptySubAggregations(), this.metadata());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        if (sub.isNoop()) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        Scorer scorer = this.getWeight().scorer(aggCtx.getLeafReaderContext());
        if (scorer == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        sub.setScorer((Scorable)scorer);
        if (this.probability >= 1.0) {
            this.grow(1L);
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    RandomSamplerAggregator.this.collectExistingBucket(sub, doc, 0L);
                }
            };
        }
        DocIdSetIterator docIt = scorer.iterator();
        Bits liveDocs = aggCtx.getLeafReaderContext().reader().getLiveDocs();
        try {
            this.grow(1L);
            int docId = docIt.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                if (liveDocs == null || liveDocs.get(docIt.docID())) {
                    this.collectExistingBucket(sub, docIt.docID(), 0L);
                }
                docId = docIt.nextDoc();
            }
        }
        catch (CollectionTerminatedException e) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        return LeafBucketCollector.NO_OP_COLLECTOR;
    }
}

