/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.List;
import java.util.function.BiFunction;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.KeyComparable;

public final class DelayedBucket<B extends InternalMultiBucketAggregation.InternalBucket> {
    private List<B> toReduce;
    private B reduced;
    private long docCount = -1L;

    public DelayedBucket(List<B> toReduce) {
        this.toReduce = toReduce;
    }

    public B reduced(BiFunction<List<B>, AggregationReduceContext, B> reduce, AggregationReduceContext reduceContext) {
        if (this.reduced == null) {
            this.reduced = (InternalMultiBucketAggregation.InternalBucket)reduce.apply(this.toReduce, reduceContext);
            this.toReduce = null;
        }
        return this.reduced;
    }

    public long getDocCount() {
        if (this.docCount < 0L) {
            if (this.reduced == null) {
                this.docCount = 0L;
                for (InternalMultiBucketAggregation.InternalBucket bucket : this.toReduce) {
                    this.docCount += bucket.getDocCount();
                }
            } else {
                this.docCount = this.reduced.getDocCount();
            }
        }
        return this.docCount;
    }

    int compareKey(DelayedBucket<?> rhs) {
        return ((KeyComparable)this.representativeBucket()).compareKey(rhs.representativeBucket());
    }

    private B representativeBucket() {
        return (B)(this.reduced == null ? (InternalMultiBucketAggregation.InternalBucket)this.toReduce.get(0) : this.reduced);
    }

    public String toString() {
        return "Delayed[" + this.representativeBucket().getKeyAsString() + "]";
    }

    void nonCompetitive(AggregationReduceContext reduceContext) {
        if (this.reduced != null) {
            reduceContext.consumeBucketsAndMaybeBreak(-InternalMultiBucketAggregation.countInnerBucket(this.reduced));
        }
    }
}

