/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;

@FunctionalInterface
public interface RestHandler {
    public void handleRequest(RestRequest var1, RestChannel var2, NodeClient var3) throws Exception;

    default public boolean canTripCircuitBreaker() {
        return true;
    }

    default public boolean supportsContentStream() {
        return false;
    }

    default public boolean supportsBulkContent() {
        return false;
    }

    default public RestHandler getConcreteRestHandler() {
        return this;
    }

    default public Scope getServerlessScope() {
        ServerlessScope serverlessScope = this.getConcreteRestHandler().getClass().getAnnotation(ServerlessScope.class);
        return serverlessScope == null ? null : serverlessScope.value();
    }

    default public List<Route> routes() {
        return Collections.emptyList();
    }

    @Nullable
    default public Set<String> allSupportedParameters() {
        return this.supportedQueryParameters();
    }

    @Nullable
    default public Set<String> supportedQueryParameters() {
        return null;
    }

    default public Set<String> supportedCapabilities() {
        return Set.of();
    }

    default public boolean allowSystemIndexAccessByDefault() {
        return false;
    }

    default public boolean mediaTypesValid(RestRequest request) {
        return request.getXContentType() != null;
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public static class Route {
        private final RestRequest.Method method;
        private final String path;
        private final RestApiVersion restApiVersion;
        @Nullable
        private final String deprecationMessage;
        private final Level deprecationLevel;
        @Nullable
        private final Route replacedRoute;

        private Route(RestRequest.Method method, String path, RestApiVersion restApiVersion, String deprecationMessage, Level deprecationLevel, Route replacedRoute) {
            this.method = Objects.requireNonNull(method);
            this.path = Objects.requireNonNull(path);
            this.restApiVersion = Objects.requireNonNull(restApiVersion);
            this.deprecationMessage = deprecationMessage;
            this.deprecationLevel = Objects.requireNonNull(deprecationLevel);
            if (deprecationMessage == null && deprecationLevel != Level.OFF) {
                throw new IllegalArgumentException("deprecationMessage must be set if deprecationLevel is not OFF");
            }
            this.replacedRoute = replacedRoute;
        }

        public Route(RestRequest.Method method, String path) {
            this(method, path, RestApiVersion.current(), null, Level.OFF, null);
        }

        public static RouteBuilder builder(RestRequest.Method method, String path) {
            return new RouteBuilder(method, path);
        }

        public String getPath() {
            return this.path;
        }

        public RestRequest.Method getMethod() {
            return this.method;
        }

        public RestApiVersion getRestApiVersion() {
            return this.restApiVersion;
        }

        @Nullable
        public String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public Level getDeprecationLevel() {
            return this.deprecationLevel;
        }

        public boolean isDeprecated() {
            return this.deprecationMessage != null;
        }

        @Nullable
        public Route getReplacedRoute() {
            return this.replacedRoute;
        }

        public boolean hasReplacement() {
            return this.replacedRoute != null;
        }

        public static class RouteBuilder {
            private final RestRequest.Method method;
            private final String path;
            private RestApiVersion restApiVersion;
            private String deprecationMessage;
            private Level deprecationLevel;
            private Route replacedRoute;

            private RouteBuilder(RestRequest.Method method, String path) {
                this.method = Objects.requireNonNull(method);
                this.path = Objects.requireNonNull(path);
                this.restApiVersion = RestApiVersion.current();
            }

            public RouteBuilder deprecatedForRemoval(String deprecationMessage, RestApiVersion lastFullySupportedVersion) {
                assert (this.replacedRoute == null);
                this.restApiVersion = Objects.requireNonNull(lastFullySupportedVersion);
                this.deprecationMessage = Objects.requireNonNull(deprecationMessage);
                this.deprecationLevel = lastFullySupportedVersion == RestApiVersion.current() ? Level.WARN : DeprecationLogger.CRITICAL;
                return this;
            }

            public RouteBuilder replaces(RestRequest.Method replacedMethod, String replacedPath, RestApiVersion lastFullySupportedVersion) {
                assert (this.deprecationMessage == null);
                Level deprecationLevel = lastFullySupportedVersion == RestApiVersion.current() ? Level.WARN : DeprecationLogger.CRITICAL;
                String replacedMessage = "[" + replacedMethod.name() + " " + replacedPath + "] is deprecated! Use [" + this.method.name() + " " + this.path + "] instead.";
                this.replacedRoute = new Route(replacedMethod, replacedPath, lastFullySupportedVersion, replacedMessage, deprecationLevel, null);
                return this;
            }

            public RouteBuilder deprecateAndKeep(String deprecationMessage) {
                assert (this.replacedRoute == null);
                this.restApiVersion = RestApiVersion.current();
                this.deprecationMessage = Objects.requireNonNull(deprecationMessage);
                this.deprecationLevel = Level.WARN;
                return this;
            }

            public Route build() {
                assert (this.deprecationMessage != null == (this.deprecationLevel != null));
                return new Route(this.method, this.path, this.restApiVersion, this.deprecationMessage, this.deprecationLevel == null ? Level.OFF : this.deprecationLevel, this.replacedRoute);
            }
        }
    }
}

