/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.util;

import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;

public final class CombinedBits
implements Bits {
    private final Bits first;
    private final Bits second;
    private final int length;

    public CombinedBits(Bits first, Bits second) {
        if (first.length() != second.length()) {
            throw new IllegalArgumentException("Provided bits have different lengths: " + first.length() + " != " + second.length());
        }
        this.first = first;
        this.second = second;
        this.length = first.length();
    }

    public boolean get(int index) {
        return this.first.get(index) && this.second.get(index);
    }

    public int length() {
        return this.length;
    }

    public void applyMask(FixedBitSet bitSet, int offset) {
        this.first.applyMask(bitSet, offset);
        this.second.applyMask(bitSet, offset);
    }
}

