/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import org.elasticsearch.injection.guice.internal.MoreTypes;
import org.elasticsearch.injection.guice.internal.SourceProvider;

public class StackTraceElements {
    public static Object forMember(Member member) {
        if (member == null) {
            return SourceProvider.UNKNOWN_SOURCE;
        }
        Class<?> declaringClass = member.getDeclaringClass();
        int lineNumber = -1;
        Class<? extends Member> memberType = MoreTypes.memberType(member);
        String memberName = memberType == Constructor.class ? "<init>" : member.getName();
        return new StackTraceElement(declaringClass.getName(), memberName, null, lineNumber);
    }

    public static Object forType(Class<?> implementation) {
        String fileName = null;
        int lineNumber = -1;
        return new StackTraceElement(implementation.getName(), "class", fileName, lineNumber);
    }
}

