/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import org.elasticsearch.injection.guice.ConstructorInjector;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.Key;
import org.elasticsearch.injection.guice.Scopes;
import org.elasticsearch.injection.guice.internal.BindingImpl;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;
import org.elasticsearch.injection.guice.internal.InternalFactory;
import org.elasticsearch.injection.guice.internal.Scoping;
import org.elasticsearch.injection.guice.internal.ToStringBuilder;
import org.elasticsearch.injection.guice.spi.BindingTargetVisitor;
import org.elasticsearch.injection.guice.spi.ConstructorBinding;
import org.elasticsearch.injection.guice.spi.Dependency;

class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T> {
    private final Factory<T> factory;

    private ConstructorBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> scopedFactory, Scoping scoping, Factory<T> factory) {
        super(injector, key, source, scopedFactory, scoping);
        this.factory = factory;
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injector, Key<T> key, Object source, Scoping scoping) {
        Factory factoryFactory = new Factory();
        InternalFactory scopedFactory = Scopes.scope(injector, factoryFactory, scoping);
        return new ConstructorBindingImpl<T>(injector, key, source, scopedFactory, scoping, factoryFactory);
    }

    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        this.factory.constructorInjector = injector.constructors.get(this.getKey().getTypeLiteral(), errors);
    }

    @Override
    public <V> void acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        if (this.factory.constructorInjector == null) {
            throw new IllegalStateException("not initialized");
        }
        visitor.visit();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ConstructorBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", (Object)this.getScoping()).toString();
    }

    private static class Factory<T>
    implements InternalFactory<T> {
        private ConstructorInjector<T> constructorInjector;

        private Factory() {
        }

        @Override
        public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
            if (this.constructorInjector == null) {
                throw new IllegalStateException("Constructor not ready");
            }
            return (T)this.constructorInjector.construct(errors, context, dependency.getKey().getRawType());
        }
    }
}

