/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.ingest.IngestStats;

class IngestMetric {
    private static final Logger logger = LogManager.getLogger(IngestMetric.class);
    private final CounterMetric ingestTimeInNanos = new CounterMetric();
    private final AtomicLong ingestCurrent = new AtomicLong();
    private final CounterMetric ingestCount = new CounterMetric();
    private final CounterMetric ingestFailed = new CounterMetric();

    IngestMetric() {
    }

    void preIngest() {
        this.ingestCurrent.incrementAndGet();
    }

    void postIngest(long ingestTimeInNanos) {
        long current = this.ingestCurrent.decrementAndGet();
        if (current < 0L) {
            logger.warn("Current ingest counter decremented below 0", (Throwable)new RuntimeException());
            assert (false) : "ingest metric current count double-decremented";
            this.ingestCurrent.incrementAndGet();
        }
        this.ingestTimeInNanos.inc(ingestTimeInNanos);
        this.ingestCount.inc();
    }

    void ingestFailed() {
        this.ingestFailed.inc();
    }

    void add(IngestMetric metrics) {
        this.ingestCount.inc(metrics.ingestCount.count());
        this.ingestTimeInNanos.inc(metrics.ingestTimeInNanos.count());
        this.ingestFailed.inc(metrics.ingestFailed.count());
    }

    IngestStats.Stats createStats() {
        long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.ingestTimeInNanos.count());
        long currentCount = Math.max(0L, this.ingestCurrent.get());
        return new IngestStats.Stats(this.ingestCount.count(), ingestTimeInMillis, currentCount, this.ingestFailed.count());
    }
}

