/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.inference.telemetry;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.UnparsedModel;
import org.elasticsearch.telemetry.metric.LongCounter;
import org.elasticsearch.telemetry.metric.LongHistogram;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public record InferenceStats(LongCounter requestCount, LongHistogram inferenceDuration, LongHistogram deploymentDuration) {
    public InferenceStats {
        Objects.requireNonNull(requestCount);
        Objects.requireNonNull(inferenceDuration);
        Objects.requireNonNull(deploymentDuration);
    }

    public static InferenceStats create(MeterRegistry meterRegistry) {
        return new InferenceStats(meterRegistry.registerLongCounter("es.inference.requests.count.total", "Inference API request counts for a particular service, task type, model ID", "operations"), meterRegistry.registerLongHistogram("es.inference.requests.time", "Inference API request counts for a particular service, task type, model ID", "ms"), meterRegistry.registerLongHistogram("es.inference.trained_model.deployment.time", "Inference API time spent waiting for Trained Model Deployments", "ms"));
    }

    public static Map<String, Object> modelAttributes(Model model) {
        HashMap<String, Object> modelAttributesMap = new HashMap<String, Object>();
        modelAttributesMap.put("service", model.getConfigurations().getService());
        modelAttributesMap.put("task_type", model.getTaskType().toString());
        if (Objects.nonNull(model.getServiceSettings().modelId())) {
            modelAttributesMap.put("model_id", model.getServiceSettings().modelId());
        }
        return modelAttributesMap;
    }

    public static Map<String, Object> modelAttributes(UnparsedModel model) {
        return Map.of("service", model.service(), "task_type", model.taskType().toString());
    }

    public static Map<String, Object> responseAttributes(@Nullable Throwable throwable) {
        if (Objects.isNull(throwable)) {
            return Map.of("status_code", 200);
        }
        if (throwable instanceof ElasticsearchStatusException) {
            ElasticsearchStatusException ese = (ElasticsearchStatusException)throwable;
            return Map.of("status_code", ese.status().getStatus(), "error.type", String.valueOf(ese.status().getStatus()));
        }
        return Map.of("error.type", throwable.getClass().getSimpleName());
    }

    public static Map<String, Object> modelAndResponseAttributes(Model model, @Nullable Throwable throwable) {
        HashMap<String, Object> metricAttributes = new HashMap<String, Object>();
        metricAttributes.putAll(InferenceStats.modelAttributes(model));
        metricAttributes.putAll(InferenceStats.responseAttributes(throwable));
        return metricAttributes;
    }
}

