/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.NodeStatsLevel;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.bulk.stats.BulkStats;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.cache.request.RequestCacheStats;
import org.elasticsearch.index.engine.SegmentsStats;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.NodeMappingStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.shard.DenseVectorStats;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IndexingStats;
import org.elasticsearch.index.shard.ShardCountStats;
import org.elasticsearch.index.shard.SparseVectorStats;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.TranslogStats;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.search.suggest.completion.CompletionStats;
import org.elasticsearch.xcontent.ToXContent;

public class NodeIndicesStats
implements Writeable,
ChunkedToXContent {
    private static final TransportVersion VERSION_SUPPORTING_STATS_BY_INDEX = TransportVersions.V_8_5_0;
    private static final TransportVersion NODES_STATS_SUPPORTS_MULTI_PROJECT = TransportVersion.fromName("nodes_stats_supports_multi_project");
    private static final Map<Index, List<IndexShardStats>> EMPTY_STATS_BY_SHARD = Map.of();
    private final CommonStats stats;
    private final Map<Index, List<IndexShardStats>> statsByShard;
    private final Map<Index, CommonStats> statsByIndex;
    private final Map<Index, ProjectId> projectsByIndex;

    public NodeIndicesStats(StreamInput in) throws IOException {
        this.stats = new CommonStats(in);
        this.statsByShard = new HashMap<Index, List<IndexShardStats>>();
        int entries = in.readVInt();
        for (int i = 0; i < entries; ++i) {
            Index index = new Index(in);
            int indexShardListSize = in.readVInt();
            ArrayList<IndexShardStats> indexShardStats = new ArrayList<IndexShardStats>(indexShardListSize);
            for (int j = 0; j < indexShardListSize; ++j) {
                indexShardStats.add(new IndexShardStats(in));
            }
            this.statsByShard.put(index, indexShardStats);
        }
        this.statsByIndex = in.getTransportVersion().onOrAfter(VERSION_SUPPORTING_STATS_BY_INDEX) ? in.readMap(Index::new, CommonStats::new) : new HashMap<Index, CommonStats>();
        this.projectsByIndex = in.getTransportVersion().supports(NODES_STATS_SUPPORTS_MULTI_PROJECT) ? in.readMap(Index::new, ProjectId::readFrom) : Map.of();
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, CommonStats> statsByIndex, Map<Index, List<IndexShardStats>> statsByShard, Map<Index, ProjectId> projectsByIndex, boolean includeShardsStats) {
        this.statsByShard = includeShardsStats ? Objects.requireNonNull(statsByShard) : EMPTY_STATS_BY_SHARD;
        this.statsByIndex = Objects.requireNonNull(statsByIndex);
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
        for (CommonStats indexStats : statsByIndex.values()) {
            this.stats.add(indexStats);
        }
        this.projectsByIndex = Objects.requireNonNull(projectsByIndex);
    }

    @Nullable
    public StoreStats getStore() {
        return this.stats.getStore();
    }

    @Nullable
    public DocsStats getDocs() {
        return this.stats.getDocs();
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.stats.getIndexing();
    }

    @Nullable
    public GetStats getGet() {
        return this.stats.getGet();
    }

    @Nullable
    public SearchStats getSearch() {
        return this.stats.getSearch();
    }

    @Nullable
    public MergeStats getMerge() {
        return this.stats.getMerge();
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.stats.getRefresh();
    }

    @Nullable
    public FlushStats getFlush() {
        return this.stats.getFlush();
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.stats.getWarmer();
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.stats.getFieldData();
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.stats.getQueryCache();
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.stats.getRequestCache();
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.stats.getCompletion();
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.stats.getSegments();
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.stats.getTranslog();
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.stats.getRecoveryStats();
    }

    @Nullable
    public BulkStats getBulk() {
        return this.stats.getBulk();
    }

    @Nullable
    public ShardCountStats getShardCount() {
        return this.stats.getShards();
    }

    @Nullable
    public NodeMappingStats getNodeMappingStats() {
        return this.stats.getNodeMappings();
    }

    @Nullable
    public DenseVectorStats getDenseVectorStats() {
        return this.stats.getDenseVectorStats();
    }

    @Nullable
    public SparseVectorStats getSparseVectorStats() {
        return this.stats.getSparseVectorStats();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        out.writeMap(this.statsByShard, StreamOutput::writeWriteable, StreamOutput::writeCollection);
        if (out.getTransportVersion().onOrAfter(VERSION_SUPPORTING_STATS_BY_INDEX)) {
            out.writeMap(this.statsByIndex);
        }
        if (out.getTransportVersion().supports(NODES_STATS_SUPPORTS_MULTI_PROJECT)) {
            out.writeMap(this.projectsByIndex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeIndicesStats that = (NodeIndicesStats)o;
        return this.stats.equals(that.stats) && this.statsByShard.equals(that.statsByShard) && this.statsByIndex.equals(that.statsByIndex) && this.projectsByIndex.equals(that.projectsByIndex);
    }

    public int hashCode() {
        return Objects.hash(this.stats, this.statsByShard, this.statsByIndex, this.projectsByIndex);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params outerParams) {
        Iterator[] iteratorArray = new Iterator[3];
        iteratorArray[0] = Iterators.single((builder, params) -> {
            builder.startObject("indices");
            return this.stats.toXContent(builder, outerParams);
        });
        iteratorArray[1] = switch (NodeStatsLevel.of(outerParams, NodeStatsLevel.NODE)) {
            default -> throw new MatchException(null, null);
            case NodeStatsLevel.NODE -> Collections.emptyIterator();
            case NodeStatsLevel.INDICES -> ChunkedToXContentHelper.object("indices", Iterators.map(this.createCommonStatsByIndex().entrySet().iterator(), entry -> (builder, params) -> {
                builder.startObject(this.xContentKey((Index)entry.getKey(), outerParams));
                ((CommonStats)entry.getValue()).toXContent(builder, outerParams);
                return builder.endObject();
            }));
            case NodeStatsLevel.SHARDS -> ChunkedToXContentHelper.object("shards", Iterators.flatMap(this.statsByShard.entrySet().iterator(), entry -> ChunkedToXContentHelper.array(this.xContentKey((Index)entry.getKey(), outerParams), Iterators.flatMap(((List)entry.getValue()).iterator(), indexShardStats -> Iterators.concat(Iterators.single((b, p) -> b.startObject().startObject(String.valueOf(indexShardStats.getShardId().getId()))), Iterators.flatMap(Iterators.forArray(indexShardStats.getShards()), Iterators::single), Iterators.single((b, p) -> b.endObject().endObject()))))));
        };
        iteratorArray[2] = ChunkedToXContentHelper.endObject();
        return Iterators.concat(iteratorArray);
    }

    private String xContentKey(Index index, ToXContent.Params outerParams) {
        if (outerParams.paramAsBoolean("multi_project_enabled_node_stats", false)) {
            ProjectId projectId = this.projectsByIndex.get(index);
            if (projectId == null) {
                return "<unknown>/" + index.getName() + "/" + index.getUUID();
            }
            return String.valueOf(projectId) + "/" + index.getName();
        }
        return index.getName();
    }

    private Map<Index, CommonStats> createCommonStatsByIndex() {
        HashMap<Index, CommonStats> statsMap = new HashMap<Index, CommonStats>();
        for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
            if (!statsMap.containsKey(entry.getKey())) {
                statsMap.put(entry.getKey(), new CommonStats());
            }
            for (IndexShardStats indexShardStats : entry.getValue()) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    ((CommonStats)statsMap.get(entry.getKey())).add(shardStats.getStats());
                }
            }
        }
        for (Map.Entry<Index, Object> entry : this.statsByIndex.entrySet()) {
            statsMap.computeIfAbsent(entry.getKey(), k -> new CommonStats()).add((CommonStats)entry.getValue());
        }
        return statsMap;
    }

    public List<IndexShardStats> getShardStats(Index index) {
        return this.statsByShard.get(index);
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

