/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.core.Strings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;

public class IndexingFailuresDebugListener
implements IndexingOperationListener {
    private static final Logger LOGGER = LogManager.getLogger(IndexingFailuresDebugListener.class);
    private final IndexShard indexShard;

    public IndexingFailuresDebugListener(IndexShard indexShard) {
        this.indexShard = indexShard;
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Engine.IndexResult result) {
        if (LOGGER.isDebugEnabled() && result.getResultType() == Engine.Result.Type.FAILURE) {
            this.postIndex(shardId, index, result.getFailure());
        }
    }

    @Override
    public void postIndex(ShardId shardId, Engine.Index index, Exception ex) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(() -> Strings.format((String)"index-fail [%s] seq# [%s] allocation-id [%s] primaryTerm [%s] operationPrimaryTerm [%s] origin [%s]", (Object[])new Object[]{index.id(), index.seqNo(), this.indexShard.routingEntry().allocationId(), index.primaryTerm(), this.indexShard.getOperationPrimaryTerm(), index.origin()}), (Throwable)ex);
        }
    }
}

