/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.QueryValidationException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class GeoBoundingBoxQueryBuilder
extends AbstractQueryBuilder<GeoBoundingBoxQueryBuilder> {
    public static final String NAME = "geo_bounding_box";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField VALIDATION_METHOD_FIELD = new ParseField("validation_method", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String fieldName;
    private GeoBoundingBox geoBoundingBox = new GeoBoundingBox(new GeoPoint(Double.NaN, Double.NaN), new GeoPoint(Double.NaN, Double.NaN));
    private GeoValidationMethod validationMethod = GeoValidationMethod.DEFAULT;
    private boolean ignoreUnmapped = false;

    public GeoBoundingBoxQueryBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Field name must not be empty.");
        }
        this.fieldName = fieldName;
    }

    public GeoBoundingBoxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.geoBoundingBox = new GeoBoundingBox(in);
        this.validationMethod = GeoValidationMethod.readFromStream(in);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        this.geoBoundingBox.writeTo(out);
        this.validationMethod.writeTo(out);
        out.writeBoolean(this.ignoreUnmapped);
    }

    public GeoBoundingBoxQueryBuilder setCorners(double top, double left, double bottom, double right) {
        if (!GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            if (!Numbers.isValidDouble(top)) {
                throw new IllegalArgumentException("top latitude is invalid: " + top);
            }
            if (!Numbers.isValidDouble(left)) {
                throw new IllegalArgumentException("left longitude is invalid: " + left);
            }
            if (!Numbers.isValidDouble(bottom)) {
                throw new IllegalArgumentException("bottom latitude is invalid: " + bottom);
            }
            if (!Numbers.isValidDouble(right)) {
                throw new IllegalArgumentException("right longitude is invalid: " + right);
            }
            if (top < bottom) {
                throw new IllegalArgumentException("top is below bottom corner: " + top + " vs. " + bottom);
            }
        }
        this.geoBoundingBox.topLeft().reset(top, left);
        this.geoBoundingBox.bottomRight().reset(bottom, right);
        return this;
    }

    public GeoBoundingBoxQueryBuilder setCorners(GeoPoint topLeft, GeoPoint bottomRight) {
        return this.setCorners(topLeft.getLat(), topLeft.getLon(), bottomRight.getLat(), bottomRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCorners(String geohash) {
        Rectangle ghBBox = Geohash.toBoundingBox((String)geohash);
        return this.setCorners(new GeoPoint(ghBBox.getMaxY(), ghBBox.getMinX()), new GeoPoint(ghBBox.getMinY(), ghBBox.getMaxX()));
    }

    public GeoBoundingBoxQueryBuilder setCorners(String topLeft, String bottomRight) {
        return this.setCorners(GeoPoint.fromGeohash(topLeft), GeoPoint.fromGeohash(bottomRight));
    }

    public GeoPoint topLeft() {
        return this.geoBoundingBox.topLeft();
    }

    public GeoPoint bottomRight() {
        return this.geoBoundingBox.bottomRight();
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(GeoPoint bottomLeft, GeoPoint topRight) {
        return this.setCorners(topRight.getLat(), bottomLeft.getLon(), bottomLeft.getLat(), topRight.getLon());
    }

    public GeoBoundingBoxQueryBuilder setCornersOGC(String bottomLeft, String topRight) {
        return this.setCornersOGC(GeoPoint.fromGeohash(bottomLeft), GeoPoint.fromGeohash(topRight));
    }

    public GeoBoundingBoxQueryBuilder setValidationMethod(GeoValidationMethod method) {
        this.validationMethod = method;
        return this;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public GeoBoundingBoxQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    QueryValidationException checkLatLon() {
        if (GeoValidationMethod.isIgnoreMalformed(this.validationMethod)) {
            return null;
        }
        GeoPoint topLeft = this.geoBoundingBox.topLeft();
        GeoPoint bottomRight = this.geoBoundingBox.bottomRight();
        QueryValidationException validationException = null;
        if (!GeoUtils.isValidLatitude(topLeft.getLat())) {
            validationException = this.addValidationError("top latitude is invalid: " + topLeft.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(topLeft.getLon())) {
            validationException = this.addValidationError("left longitude is invalid: " + topLeft.getLon(), validationException);
        }
        if (!GeoUtils.isValidLatitude(bottomRight.getLat())) {
            validationException = this.addValidationError("bottom latitude is invalid: " + bottomRight.getLat(), validationException);
        }
        if (!GeoUtils.isValidLongitude(bottomRight.getLon())) {
            validationException = this.addValidationError("right longitude is invalid: " + bottomRight.getLon(), validationException);
        }
        return validationException;
    }

    @Override
    public Query doToQuery(SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new QueryShardException((QueryRewriteContext)context, "failed to find geo field [" + this.fieldName + "]", new Object[0]);
        }
        if (!(fieldType instanceof GeoShapeQueryable)) {
            throw new QueryShardException((QueryRewriteContext)context, "Field [" + this.fieldName + "] is of unsupported type [" + fieldType.typeName() + "] for [geo_bounding_box] query", new Object[0]);
        }
        QueryValidationException exception = this.checkLatLon();
        if (exception != null) {
            throw new QueryShardException((QueryRewriteContext)context, "couldn't validate latitude/ longitude values", (Throwable)exception, new Object[0]);
        }
        GeoPoint luceneTopLeft = new GeoPoint(this.geoBoundingBox.topLeft());
        GeoPoint luceneBottomRight = new GeoPoint(this.geoBoundingBox.bottomRight());
        if (GeoValidationMethod.isCoerce(this.validationMethod)) {
            double left;
            double right = luceneBottomRight.getLon();
            boolean completeLonRange = (right - (left = luceneTopLeft.getLon())) % 360.0 == 0.0 && right > left;
            GeoUtils.normalizePoint(luceneTopLeft, true, !completeLonRange);
            GeoUtils.normalizePoint(luceneBottomRight, true, !completeLonRange);
            if (completeLonRange) {
                luceneTopLeft.resetLon(-180.0);
                luceneBottomRight.resetLon(180.0);
            }
        }
        GeoShapeQueryable geoShapeQueryable = (GeoShapeQueryable)((Object)fieldType);
        Rectangle rectangle = new Rectangle(luceneTopLeft.getLon(), luceneBottomRight.getLon(), luceneTopLeft.getLat(), luceneBottomRight.getLat());
        return geoShapeQueryable.geoShapeQuery(context, fieldType.name(), SpatialStrategy.RECURSIVE, ShapeRelation.INTERSECTS, (Geometry)rectangle);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        this.geoBoundingBox.toXContentFragmentWithArray(builder);
        builder.endObject();
        builder.field(VALIDATION_METHOD_FIELD.getPreferredName(), (Enum)this.validationMethod);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static GeoBoundingBoxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        GeoBoundingBox bbox = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                try {
                    bbox = GeoBoundingBox.parseBoundingBox(parser);
                    fieldName = currentFieldName;
                    continue;
                }
                catch (Exception e) {
                    throw new ElasticsearchParseException("failed to parse [{}] query. [{}]", NAME, e.getMessage());
                }
            }
            if (!token.isValue()) continue;
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (VALIDATION_METHOD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                validationMethod = GeoValidationMethod.fromString(parser.text());
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [{}] query. unexpected field [{}]", NAME, currentFieldName);
        }
        if (bbox == null) {
            throw new ElasticsearchParseException("failed to parse [{}] query. bounding box not provided", NAME);
        }
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(bbox.topLeft(), bbox.bottomRight());
        builder.queryName(queryName);
        builder.boost(boost);
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        return builder;
    }

    @Override
    protected boolean doEquals(GeoBoundingBoxQueryBuilder other) {
        return Objects.equals(this.geoBoundingBox, other.geoBoundingBox) && Objects.equals(this.validationMethod, other.validationMethod) && Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.ignoreUnmapped, other.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.geoBoundingBox, this.validationMethod, this.fieldName, this.ignoreUnmapped);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }
}

