/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.FeatureFlag;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DynamicFieldsBuilder;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperErrors;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperMergeContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.XContentDataHelper;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ObjectMapper
extends Mapper {
    private static final Logger logger = LogManager.getLogger(ObjectMapper.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ObjectMapper.class);
    public static final boolean SUB_OBJECTS_AUTO_FEATURE_FLAG = new FeatureFlag("sub_objects_auto").isEnabled();
    static final NodeFeature SUBOBJECTS_FALSE_MAPPING_UPDATE_FIX = new NodeFeature("mapper.subobjects_false_mapping_update_fix");
    public static final String CONTENT_TYPE = "object";
    static final String STORE_ARRAY_SOURCE_PARAM = "store_array_source";
    private final String fullPath;
    protected final Explicit<Boolean> enabled;
    protected final Explicit<Subobjects> subobjects;
    protected final Optional<Mapper.SourceKeepMode> sourceKeepMode;
    protected final Dynamic dynamic;
    protected final Map<String, Mapper> mappers;

    @Override
    public int getTotalFieldsCount() {
        int sum = 1;
        for (Mapper mapper : this.mappers.values()) {
            sum += mapper.getTotalFieldsCount();
        }
        return sum;
    }

    private static void validateFieldName(String fieldName, IndexVersion indexCreatedVersion) {
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("field name cannot be an empty string");
        }
        if (fieldName.isBlank() & indexCreatedVersion.onOrAfter(IndexVersions.V_8_6_0)) {
            throw new IllegalArgumentException("field name cannot contain only whitespaces");
        }
    }

    ObjectMapper(String name, String fullPath, Explicit<Boolean> enabled, Explicit<Subobjects> subobjects, Optional<Mapper.SourceKeepMode> sourceKeepMode, Dynamic dynamic, Map<String, Mapper> mappers) {
        super(name);
        assert (!name.isEmpty());
        this.fullPath = ObjectMapper.internFieldName(fullPath);
        this.enabled = enabled;
        this.subobjects = subobjects;
        this.sourceKeepMode = sourceKeepMode;
        this.dynamic = dynamic;
        this.mappers = mappers == null ? Map.of() : Map.copyOf(mappers);
        assert (subobjects.value() != Subobjects.DISABLED || this.mappers.values().stream().noneMatch(m -> m instanceof ObjectMapper)) : "When subobjects is false, mappers must not contain an ObjectMapper";
    }

    public Builder newBuilder(IndexVersion indexVersionCreated) {
        Builder builder = new Builder(this.leafName(), this.subobjects);
        builder.enabled = this.enabled;
        builder.dynamic = this.dynamic;
        return builder;
    }

    ObjectMapper withoutMappers() {
        return new ObjectMapper(this.leafName(), this.fullPath, this.enabled, this.subobjects, this.sourceKeepMode, this.dynamic, Map.of());
    }

    @Override
    public String fullPath() {
        return this.fullPath;
    }

    @Override
    public String typeName() {
        return CONTENT_TYPE;
    }

    public boolean isEnabled() {
        return this.enabled.value();
    }

    public boolean isNested() {
        return false;
    }

    public Mapper getMapper(String field) {
        return this.mappers.get(field);
    }

    @Override
    public Iterator<Mapper> iterator() {
        return this.mappers.values().iterator();
    }

    public final Dynamic dynamic() {
        return this.dynamic;
    }

    public final Subobjects subobjects() {
        return this.subobjects.value();
    }

    public final Optional<Mapper.SourceKeepMode> sourceKeepMode() {
        return this.sourceKeepMode;
    }

    @Override
    public final void validate(MappingLookup mappers) {
        for (Mapper mapper : this.mappers.values()) {
            this.validateSubField(mapper, mappers);
        }
    }

    protected void validateSubField(Mapper mapper, MappingLookup mappers) {
        mapper.validate(mappers);
    }

    protected MapperMergeContext createChildContext(MapperMergeContext mapperMergeContext, String name) {
        return mapperMergeContext.createChildContext(name, this.dynamic);
    }

    @Override
    public ObjectMapper merge(Mapper mergeWith, MapperMergeContext parentMergeContext) {
        if (!(mergeWith instanceof ObjectMapper)) {
            MapperErrors.throwObjectMappingConflictError(mergeWith.fullPath());
        }
        if (!(this instanceof NestedObjectMapper) && mergeWith instanceof NestedObjectMapper) {
            MapperErrors.throwNestedMappingConflictError(mergeWith.fullPath());
        }
        MergeResult mergeResult = MergeResult.build(this, (ObjectMapper)mergeWith, parentMergeContext);
        if (mergeWith instanceof PassThroughObjectMapper) {
            PassThroughObjectMapper passThroughObjectMapper = (PassThroughObjectMapper)mergeWith;
            if (PassThroughObjectMapper.isEligibleForMerge(this)) {
                return new PassThroughObjectMapper(this.leafName(), this.fullPath, mergeResult.enabled, mergeResult.sourceKeepMode, mergeResult.dynamic, mergeResult.mappers, passThroughObjectMapper.timeSeriesDimensionSubFields(), passThroughObjectMapper.priority());
            }
            MapperErrors.throwPassThroughMappingConflictError(this.fullPath());
        }
        return new ObjectMapper(this.leafName(), this.fullPath, mergeResult.enabled, mergeResult.subObjects, mergeResult.sourceKeepMode, mergeResult.dynamic, mergeResult.mappers);
    }

    List<FieldMapper> asFlattenedFieldMappers(MapperBuilderContext context) {
        ArrayList<FieldMapper> flattenedMappers = new ArrayList<FieldMapper>();
        ContentPath path = new ContentPath();
        this.asFlattenedFieldMappers(context, flattenedMappers, path);
        return flattenedMappers;
    }

    private void asFlattenedFieldMappers(MapperBuilderContext context, List<FieldMapper> flattenedMappers, ContentPath path) {
        this.ensureFlattenable(context, path);
        path.add(this.leafName());
        for (Mapper mapper : this.mappers.values()) {
            if (mapper instanceof FieldMapper) {
                FieldMapper fieldMapper = (FieldMapper)mapper;
                FieldMapper.Builder fieldBuilder = fieldMapper.getMergeBuilder();
                fieldBuilder.setLeafName(path.pathAsText(mapper.leafName()));
                flattenedMappers.add(fieldBuilder.build(context));
                continue;
            }
            if (!(mapper instanceof ObjectMapper)) continue;
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            objectMapper.asFlattenedFieldMappers(context, flattenedMappers, path);
        }
        path.remove();
    }

    private void ensureFlattenable(MapperBuilderContext context, ContentPath path) {
        if (this.dynamic != null && context.getDynamic() != this.dynamic) {
            this.throwAutoFlatteningException(path, "the value of [dynamic] (" + String.valueOf((Object)this.dynamic) + ") is not compatible with the value from its parent context (" + String.valueOf((Object)context.getDynamic()) + ")");
        }
        if (this.sourceKeepMode.isPresent()) {
            this.throwAutoFlatteningException(path, "the value of [synthetic_source_keep] is [ " + String.valueOf((Object)this.sourceKeepMode.get()) + " ]");
        }
        if (!this.isEnabled()) {
            this.throwAutoFlatteningException(path, "the value of [enabled] is [false]");
        }
        if (this.subobjects.explicit() && this.subobjects.value() == Subobjects.ENABLED) {
            this.throwAutoFlatteningException(path, "the value of [subobjects] is [true]");
        }
    }

    private void throwAutoFlatteningException(ContentPath path, String reason) {
        throw new IllegalArgumentException("Object mapper [" + path.pathAsText(this.leafName()) + "] was found in a context where subobjects is set to false. Auto-flattening [" + path.pathAsText(this.leafName()) + "] failed because " + reason);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.toXContent(builder, params, null);
        return builder;
    }

    void toXContent(XContentBuilder builder, ToXContent.Params params, ToXContent custom) throws IOException {
        builder.startObject(this.leafName());
        if (this.mappers.isEmpty() && custom == null) {
            builder.field("type", CONTENT_TYPE);
        }
        if (this.dynamic != null) {
            builder.field("dynamic", this.dynamic.name().toLowerCase(Locale.ROOT));
        }
        if (!this.isEnabled()) {
            builder.field("enabled", this.enabled.value());
        }
        if (this.subobjects.explicit()) {
            builder.field("subobjects", this.subobjects.value().printedValue);
        }
        if (this.sourceKeepMode.isPresent()) {
            builder.field("synthetic_source_keep", (Enum)this.sourceKeepMode.get());
        }
        if (custom != null) {
            custom.toXContent(builder, params);
        }
        this.doXContent(builder, params);
        this.serializeMappers(builder, params);
        builder.endObject();
    }

    protected void serializeMappers(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Mapper[] sortedMappers = (Mapper[])this.mappers.values().toArray(Mapper[]::new);
        Arrays.sort(sortedMappers, Comparator.comparing(Mapper::fullPath));
        int count = 0;
        for (Mapper mapper : sortedMappers) {
            if (mapper instanceof MetadataFieldMapper) continue;
            if (count++ == 0) {
                builder.startObject("properties");
            }
            mapper.toXContent(builder, params);
        }
        if (count > 0) {
            builder.endObject();
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
    }

    public ObjectMapper findParentMapper(String leafFieldPath) {
        String[] pathComponents = leafFieldPath.split("\\.");
        int startPathComponent = 0;
        ObjectMapper current = this;
        String pathInCurrent = leafFieldPath;
        block0: while (current != null) {
            if (current.mappers.containsKey(pathInCurrent)) {
                return current;
            }
            ObjectMapper parent = current;
            current = null;
            StringBuilder childMapperName = new StringBuilder();
            for (int i = startPathComponent; i < pathComponents.length - 1; ++i) {
                ObjectMapper objectMapper;
                if (!childMapperName.isEmpty()) {
                    childMapperName.append(".");
                }
                childMapperName.append(pathComponents[i]);
                Mapper childMapper = parent.mappers.get(childMapperName.toString());
                if (!(childMapper instanceof ObjectMapper)) continue;
                current = objectMapper = (ObjectMapper)childMapper;
                startPathComponent = i + 1;
                pathInCurrent = pathInCurrent.substring(childMapperName.length() + 1);
                continue block0;
            }
        }
        return null;
    }

    private static SourceLoader.SyntheticVectorsLoader syntheticVectorsLoader(Mapper mapper, SourceFilter sourceFilter) {
        if (sourceFilter != null && sourceFilter.isPathFiltered(mapper.fullPath(), false)) {
            return null;
        }
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objMapper = (ObjectMapper)mapper;
            return objMapper.syntheticVectorsLoader(sourceFilter);
        }
        if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            return fieldMapper.syntheticVectorsLoader();
        }
        return null;
    }

    SourceLoader.SyntheticVectorsLoader syntheticVectorsLoader(SourceFilter sourceFilter) {
        List loaders = this.mappers.values().stream().map(m -> ObjectMapper.syntheticVectorsLoader(m, sourceFilter)).filter(l -> l != null).collect(Collectors.toList());
        if (loaders.isEmpty()) {
            return null;
        }
        return context -> {
            ArrayList<SourceLoader.SyntheticVectorsLoader.Leaf> leaves = new ArrayList<SourceLoader.SyntheticVectorsLoader.Leaf>();
            for (SourceLoader.SyntheticVectorsLoader loader : loaders) {
                SourceLoader.SyntheticVectorsLoader.Leaf leaf = loader.leaf(context);
                if (leaf == null) continue;
                leaves.add(leaf);
            }
            if (leaves.isEmpty()) {
                return null;
            }
            return (doc, acc) -> {
                for (SourceLoader.SyntheticVectorsLoader.Leaf leaf : leaves) {
                    leaf.load(doc, acc);
                }
            };
        };
    }

    SourceLoader.SyntheticFieldLoader syntheticFieldLoader(SourceFilter filter, Collection<Mapper> mappers, boolean isFragment) {
        List<SourceLoader.SyntheticFieldLoader> fields = mappers.stream().sorted(Comparator.comparing(Mapper::fullPath)).map(m -> this.innerSyntheticFieldLoader(filter, (Mapper)m)).filter(l -> l != SourceLoader.SyntheticFieldLoader.NOTHING).toList();
        return new SyntheticSourceFieldLoader(filter, fields, isFragment);
    }

    final SourceLoader.SyntheticFieldLoader syntheticFieldLoader(@Nullable SourceFilter filter) {
        return this.syntheticFieldLoader(filter, this.mappers.values(), false);
    }

    private SourceLoader.SyntheticFieldLoader innerSyntheticFieldLoader(SourceFilter filter, Mapper mapper) {
        if (mapper instanceof MetadataFieldMapper) {
            MetadataFieldMapper metaMapper = (MetadataFieldMapper)mapper;
            return metaMapper.syntheticFieldLoader();
        }
        if (filter != null && filter.isPathFiltered(mapper.fullPath(), mapper instanceof ObjectMapper)) {
            return SourceLoader.SyntheticFieldLoader.NOTHING;
        }
        if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            return objectMapper.syntheticFieldLoader(filter);
        }
        if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            return fieldMapper.syntheticFieldLoader();
        }
        return SourceLoader.SyntheticFieldLoader.NOTHING;
    }

    protected boolean isRoot() {
        return false;
    }

    public static enum Dynamic {
        TRUE{

            @Override
            DynamicFieldsBuilder getDynamicFieldsBuilder() {
                return DynamicFieldsBuilder.DYNAMIC_TRUE;
            }
        }
        ,
        FALSE,
        STRICT,
        RUNTIME{

            @Override
            DynamicFieldsBuilder getDynamicFieldsBuilder() {
                return DynamicFieldsBuilder.DYNAMIC_RUNTIME;
            }
        };


        DynamicFieldsBuilder getDynamicFieldsBuilder() {
            throw new UnsupportedOperationException("Cannot create dynamic fields when dynamic is set to [" + String.valueOf((Object)this) + "]");
        }

        static Dynamic getRootDynamic(MappingLookup mappingLookup) {
            Dynamic rootDynamic = mappingLookup.getMapping().getRoot().dynamic;
            return rootDynamic == null ? Defaults.DYNAMIC : rootDynamic;
        }
    }

    public static enum Subobjects {
        ENABLED(Boolean.TRUE),
        DISABLED(Boolean.FALSE);

        private final Object printedValue;

        private Subobjects(Object printedValue) {
            this.printedValue = printedValue;
        }

        public static Subobjects from(Object node) {
            if (node instanceof Boolean) {
                Boolean value = (Boolean)node;
                return value != false ? ENABLED : DISABLED;
            }
            if (node instanceof String) {
                String value = (String)node;
                if (value.equalsIgnoreCase("true")) {
                    return ENABLED;
                }
                if (value.equalsIgnoreCase("false")) {
                    return DISABLED;
                }
            }
            throw new ElasticsearchParseException("unknown subobjects value: " + String.valueOf(node), new Object[0]);
        }

        public String toString() {
            return this.printedValue.toString();
        }
    }

    public static class Builder
    extends Mapper.Builder {
        protected Explicit<Subobjects> subobjects;
        protected Explicit<Boolean> enabled = Explicit.IMPLICIT_TRUE;
        protected Optional<Mapper.SourceKeepMode> sourceKeepMode = Optional.empty();
        protected Dynamic dynamic;
        protected final List<Mapper.Builder> mappersBuilders = new ArrayList<Mapper.Builder>();

        public Builder(String name) {
            this(name, Defaults.SUBOBJECTS);
        }

        public Builder(String name, Explicit<Subobjects> subobjects) {
            super(name);
            this.subobjects = subobjects;
        }

        public Builder enabled(boolean enabled) {
            this.enabled = Explicit.explicitBoolean(enabled);
            return this;
        }

        public Builder sourceKeepMode(Mapper.SourceKeepMode sourceKeepMode) {
            this.sourceKeepMode = Optional.of(sourceKeepMode);
            return this;
        }

        public Builder dynamic(Dynamic dynamic) {
            this.dynamic = dynamic;
            return this;
        }

        public Builder add(Mapper.Builder builder) {
            this.mappersBuilders.add(builder);
            return this;
        }

        private void add(String name, final Mapper mapper) {
            this.add(new Mapper.Builder(this, name){

                @Override
                public Mapper build(MapperBuilderContext context) {
                    return mapper;
                }
            });
        }

        public final void addDynamic(String name, String prefix, Mapper mapper, DocumentParserContext context) {
            if (!name.contains(".") || this.subobjects.value() == Subobjects.DISABLED) {
                this.add(name, mapper);
            } else {
                int firstDotIndex = name.indexOf(46);
                String immediateChild = name.substring(0, firstDotIndex);
                Object immediateChildFullName = prefix == null ? immediateChild : prefix + "." + immediateChild;
                Builder parentBuilder = Builder.findObjectBuilder((String)immediateChildFullName, context);
                if (parentBuilder != null) {
                    parentBuilder.addDynamic(name.substring(firstDotIndex + 1), (String)immediateChildFullName, mapper, context);
                    this.add(parentBuilder);
                } else {
                    throw new IllegalStateException("Missing intermediate object " + (String)immediateChildFullName);
                }
            }
        }

        private static Builder findObjectBuilder(String fullName, DocumentParserContext context) {
            ObjectMapper objectMapper = context.mappingLookup().objectMappers().get(fullName);
            if (objectMapper != null) {
                return objectMapper.newBuilder(context.indexSettings().getIndexVersionCreated());
            }
            objectMapper = context.getDynamicObjectMapper(fullName);
            if (objectMapper != null) {
                return objectMapper.newBuilder(context.indexSettings().getIndexVersionCreated());
            }
            return null;
        }

        protected final Map<String, Mapper> buildMappers(MapperBuilderContext mapperBuilderContext) {
            HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
            for (Mapper.Builder builder : this.mappersBuilders) {
                Mapper mapper = builder.build(mapperBuilderContext);
                Mapper existing = (Mapper)mappers.get(mapper.leafName());
                if (existing != null) {
                    mapper = existing.merge(mapper, MapperMergeContext.from(mapperBuilderContext, Long.MAX_VALUE));
                }
                if (this.subobjects.value() == Subobjects.DISABLED && mapper instanceof ObjectMapper) {
                    ObjectMapper objectMapper = (ObjectMapper)mapper;
                    objectMapper.asFlattenedFieldMappers(mapperBuilderContext).forEach(m -> mappers.put(m.leafName(), (Mapper)m));
                    continue;
                }
                mappers.put(mapper.leafName(), mapper);
            }
            return mappers;
        }

        @Override
        public ObjectMapper build(MapperBuilderContext context) {
            return new ObjectMapper(this.leafName(), context.buildFullName(this.leafName()), this.enabled, this.subobjects, this.sourceKeepMode, this.dynamic, this.buildMappers(context.createChildContext(this.leafName(), this.dynamic)));
        }
    }

    protected record MergeResult(Explicit<Boolean> enabled, Explicit<Subobjects> subObjects, Optional<Mapper.SourceKeepMode> sourceKeepMode, Dynamic dynamic, Map<String, Mapper> mappers) {
        static MergeResult build(ObjectMapper existing, ObjectMapper mergeWithObject, MapperMergeContext parentMergeContext) {
            Optional<Mapper.SourceKeepMode> sourceKeepMode;
            Explicit<Subobjects> subObjects;
            Explicit<Boolean> enabled;
            MapperService.MergeReason reason = parentMergeContext.getMapperBuilderContext().getMergeReason();
            if (mergeWithObject.enabled.explicit()) {
                if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                    enabled = mergeWithObject.enabled;
                } else {
                    if (existing.isEnabled() != mergeWithObject.isEnabled()) {
                        throw new MapperException("the [enabled] parameter can't be updated for the object mapping [" + existing.fullPath() + "]");
                    }
                    enabled = existing.enabled;
                }
            } else {
                enabled = existing.enabled;
            }
            if (mergeWithObject.subobjects.explicit()) {
                if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                    subObjects = mergeWithObject.subobjects;
                } else {
                    if (existing.subobjects() != mergeWithObject.subobjects()) {
                        throw new MapperException("the [subobjects] parameter can't be updated for the object mapping [" + existing.fullPath() + "]");
                    }
                    subObjects = existing.subobjects;
                }
            } else {
                subObjects = existing.subobjects;
            }
            if (mergeWithObject.sourceKeepMode.isPresent()) {
                if (reason == MapperService.MergeReason.INDEX_TEMPLATE) {
                    sourceKeepMode = mergeWithObject.sourceKeepMode;
                } else {
                    if (existing.sourceKeepMode.isEmpty() || existing.sourceKeepMode.get() != mergeWithObject.sourceKeepMode.get()) {
                        throw new MapperException("the [ synthetic_source_keep ] parameter can't be updated for the object mapping [" + existing.fullPath() + "]");
                    }
                    sourceKeepMode = existing.sourceKeepMode;
                }
            } else {
                sourceKeepMode = existing.sourceKeepMode;
            }
            MapperMergeContext objectMergeContext = existing.createChildContext(parentMergeContext, existing.leafName());
            Map<String, Mapper> mergedMappers = MergeResult.buildMergedMappers(existing, mergeWithObject, objectMergeContext, subObjects);
            return new MergeResult(enabled, subObjects, sourceKeepMode, mergeWithObject.dynamic != null ? mergeWithObject.dynamic : existing.dynamic, mergedMappers);
        }

        private static Map<String, Mapper> buildMergedMappers(ObjectMapper existing, ObjectMapper mergeWithObject, MapperMergeContext objectMergeContext, Explicit<Subobjects> subobjects) {
            HashMap<String, Mapper> mergedMappers = new HashMap<String, Mapper>();
            for (Mapper childOfExistingMapper : existing.mappers.values()) {
                if (subobjects.value() == Subobjects.DISABLED && childOfExistingMapper instanceof ObjectMapper) {
                    ObjectMapper objectMapper = (ObjectMapper)childOfExistingMapper;
                    objectMapper.asFlattenedFieldMappers(objectMergeContext.getMapperBuilderContext()).forEach(m -> mergedMappers.put(m.leafName(), (Mapper)m));
                    continue;
                }
                MergeResult.putMergedMapper(mergedMappers, childOfExistingMapper);
            }
            for (Mapper mergeWithMapper : mergeWithObject) {
                Mapper mergeIntoMapper = (Mapper)mergedMappers.get(mergeWithMapper.leafName());
                if (mergeIntoMapper == null) {
                    if (subobjects.value() == Subobjects.DISABLED && mergeWithMapper instanceof ObjectMapper) {
                        ObjectMapper objectMapper = (ObjectMapper)mergeWithMapper;
                        List<FieldMapper> flattenedMappers = objectMapper.asFlattenedFieldMappers(objectMergeContext.getMapperBuilderContext());
                        for (FieldMapper flattenedMapper : flattenedMappers) {
                            if (!objectMergeContext.decrementFieldBudgetIfPossible(flattenedMapper.getTotalFieldsCount())) continue;
                            Mapper conflict = (Mapper)mergedMappers.get(flattenedMapper.leafName());
                            if (objectMergeContext.getMapperBuilderContext().getMergeReason() == MapperService.MergeReason.INDEX_TEMPLATE || conflict == null) {
                                MergeResult.putMergedMapper(mergedMappers, flattenedMapper);
                                continue;
                            }
                            MergeResult.putMergedMapper(mergedMappers, conflict.merge(flattenedMapper, objectMergeContext));
                        }
                        continue;
                    }
                    if (objectMergeContext.decrementFieldBudgetIfPossible(mergeWithMapper.getTotalFieldsCount())) {
                        MergeResult.putMergedMapper(mergedMappers, mergeWithMapper);
                        continue;
                    }
                    if (!(mergeWithMapper instanceof ObjectMapper)) continue;
                    ObjectMapper om = (ObjectMapper)mergeWithMapper;
                    MergeResult.putMergedMapper(mergedMappers, MergeResult.truncateObjectMapper(objectMergeContext, om));
                    continue;
                }
                if (mergeIntoMapper instanceof ObjectMapper) {
                    ObjectMapper objectMapper = (ObjectMapper)mergeIntoMapper;
                    assert (!subobjects.explicit() || subobjects.value() != Subobjects.DISABLED) : "existing object mappers are supposed to be flattened if subobjects is false";
                    MergeResult.putMergedMapper(mergedMappers, objectMapper.merge(mergeWithMapper, objectMergeContext));
                    continue;
                }
                assert (mergeIntoMapper instanceof FieldMapper || mergeIntoMapper instanceof FieldAliasMapper);
                if (mergeWithMapper instanceof NestedObjectMapper) {
                    MapperErrors.throwNestedMappingConflictError(mergeWithMapper.fullPath());
                } else if (mergeWithMapper instanceof ObjectMapper) {
                    MapperErrors.throwObjectMappingConflictError(mergeWithMapper.fullPath());
                }
                if (objectMergeContext.getMapperBuilderContext().getMergeReason() == MapperService.MergeReason.INDEX_TEMPLATE) {
                    MergeResult.putMergedMapper(mergedMappers, mergeWithMapper);
                    continue;
                }
                if (MergeResult.isConflictingDynamicMapping(objectMergeContext, mergeWithMapper, mergeIntoMapper)) {
                    logger.trace("ignoring conflicting dynamic mapping update for field={} current_type={} new_type={}", (Object)mergeIntoMapper.fullPath(), (Object)mergeIntoMapper.typeName(), (Object)mergeWithMapper.typeName());
                    continue;
                }
                MergeResult.putMergedMapper(mergedMappers, mergeIntoMapper.merge(mergeWithMapper, objectMergeContext));
            }
            return Map.copyOf(mergedMappers);
        }

        private static boolean isConflictingDynamicMapping(MapperMergeContext objectMergeContext, Mapper mergeWithMapper, Mapper mergeIntoMapper) {
            return objectMergeContext.getMapperBuilderContext().getMergeReason().isAutoUpdate() && !mergeIntoMapper.typeName().equals(mergeWithMapper.typeName());
        }

        private static void putMergedMapper(Map<String, Mapper> mergedMappers, @Nullable Mapper merged) {
            if (merged != null) {
                mergedMappers.put(merged.leafName(), merged);
            }
        }

        private static ObjectMapper truncateObjectMapper(MapperMergeContext context, ObjectMapper objectMapper) {
            ObjectMapper shallowObjectMapper = objectMapper.withoutMappers();
            if (context.decrementFieldBudgetIfPossible(shallowObjectMapper.getTotalFieldsCount())) {
                return shallowObjectMapper.merge(objectMapper, context);
            }
            return null;
        }
    }

    public static class Defaults {
        public static final boolean ENABLED = true;
        public static final Explicit<Subobjects> SUBOBJECTS = Explicit.implicit(Subobjects.ENABLED);
        public static final Explicit<Boolean> STORE_ARRAY_SOURCE = Explicit.IMPLICIT_FALSE;
        public static final Dynamic DYNAMIC = Dynamic.TRUE;
    }

    private class SyntheticSourceFieldLoader
    implements SourceLoader.SyntheticFieldLoader {
        private final SourceFilter filter;
        private final XContentParserConfiguration parserConfig;
        private final List<SourceLoader.SyntheticFieldLoader> fields;
        private final boolean isFragment;
        private boolean storedFieldLoadersHaveValues;
        private boolean docValuesLoadersHaveValues;
        private boolean ignoredValuesPresent;
        private List<IgnoredSourceFieldMapper.NameValue> ignoredValues;
        private boolean writersHaveValues;
        private TreeMap<String, FieldWriter> currentWriters;

        private SyntheticSourceFieldLoader(SourceFilter filter, List<SourceLoader.SyntheticFieldLoader> fields, boolean isFragment) {
            String fullPath;
            this.fields = fields;
            this.isFragment = isFragment;
            this.filter = filter;
            String string = fullPath = ObjectMapper.this.isRoot() ? null : ObjectMapper.this.fullPath();
            this.parserConfig = filter == null ? XContentParserConfiguration.EMPTY : XContentParserConfiguration.EMPTY.withFiltering(fullPath, filter.getIncludes() != null ? Set.of(filter.getIncludes()) : null, filter.getExcludes() != null ? Set.of(filter.getExcludes()) : null, true);
        }

        @Override
        public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
            return this.fields.stream().flatMap(SourceLoader.SyntheticFieldLoader::storedFieldLoaders).map(e -> Map.entry((String)e.getKey(), newValues -> {
                this.storedFieldLoadersHaveValues = true;
                ((SourceLoader.SyntheticFieldLoader.StoredFieldLoader)e.getValue()).load(newValues);
            }));
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders = new ArrayList<SourceLoader.SyntheticFieldLoader.DocValuesLoader>();
            for (SourceLoader.SyntheticFieldLoader field : this.fields) {
                SourceLoader.SyntheticFieldLoader.DocValuesLoader loader = field.docValuesLoader(leafReader, docIdsInLeaf);
                if (loader == null) continue;
                loaders.add(loader);
            }
            if (loaders.isEmpty()) {
                return null;
            }
            return new ObjectDocValuesLoader(loaders);
        }

        @Override
        public void prepare() {
            if (!(this.storedFieldLoadersHaveValues || this.docValuesLoadersHaveValues || this.ignoredValuesPresent)) {
                this.writersHaveValues = false;
                return;
            }
            for (SourceLoader.SyntheticFieldLoader loader : this.fields) {
                if (!(loader instanceof SyntheticSourceFieldLoader)) continue;
                SyntheticSourceFieldLoader objectSyntheticFieldLoader = (SyntheticSourceFieldLoader)loader;
                objectSyntheticFieldLoader.prepare();
            }
            this.currentWriters = new TreeMap();
            if (this.ignoredValues != null && !this.ignoredValues.isEmpty()) {
                for (IgnoredSourceFieldMapper.NameValue value : this.ignoredValues) {
                    FieldWriter existing;
                    if (value.hasValue()) {
                        this.writersHaveValues |= true;
                    }
                    if ((existing = this.currentWriters.get(value.name())) == null) {
                        this.currentWriters.put(value.name(), new FieldWriter.IgnoredSource(this.filter, value));
                        continue;
                    }
                    if (!(existing instanceof FieldWriter.IgnoredSource)) continue;
                    FieldWriter.IgnoredSource isw = (FieldWriter.IgnoredSource)existing;
                    isw.mergeWith(value);
                }
            }
            for (SourceLoader.SyntheticFieldLoader field : this.fields) {
                if (!field.hasValue()) continue;
                if (!this.currentWriters.containsKey(field.fieldName())) {
                    this.writersHaveValues |= true;
                    this.currentWriters.put(field.fieldName(), new FieldWriter.FieldLoader(field));
                    continue;
                }
                field.reset();
            }
        }

        @Override
        public boolean hasValue() {
            return this.writersHaveValues;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue()) {
                return;
            }
            if (ObjectMapper.this.isRoot() && !ObjectMapper.this.isEnabled()) {
                assert (this.ignoredValues.size() == 1) : this.ignoredValues.size();
                BytesRef value = this.ignoredValues.get(0).value();
                Optional<XContentType> type = XContentDataHelper.decodeType(value);
                assert (type.isPresent());
                XContentDataHelper.decodeAndWriteXContent(this.parserConfig, b, type.get(), this.ignoredValues.get(0).value());
                this.softReset();
                return;
            }
            if (ObjectMapper.this.isRoot() || this.isFragment) {
                b.startObject();
            } else {
                b.startObject(ObjectMapper.this.leafName());
            }
            for (FieldWriter writer : this.currentWriters.values()) {
                if (!writer.hasValue()) continue;
                writer.writeTo(b);
            }
            b.endObject();
            this.softReset();
        }

        private void softReset() {
            this.storedFieldLoadersHaveValues = false;
            this.docValuesLoadersHaveValues = false;
            this.ignoredValuesPresent = false;
            this.ignoredValues = null;
            this.writersHaveValues = false;
        }

        @Override
        public void reset() {
            this.softReset();
            this.fields.forEach(SourceLoader.SyntheticFieldLoader::reset);
        }

        @Override
        public boolean setIgnoredValues(Map<String, List<IgnoredSourceFieldMapper.NameValue>> objectsWithIgnoredFields) {
            if (objectsWithIgnoredFields == null || objectsWithIgnoredFields.isEmpty()) {
                return false;
            }
            this.ignoredValues = objectsWithIgnoredFields.remove(ObjectMapper.this.fullPath());
            this.ignoredValuesPresent |= this.ignoredValues != null;
            for (SourceLoader.SyntheticFieldLoader loader : this.fields) {
                this.ignoredValuesPresent |= loader.setIgnoredValues(objectsWithIgnoredFields);
            }
            return this.ignoredValuesPresent;
        }

        @Override
        public String fieldName() {
            return ObjectMapper.this.fullPath();
        }

        private class ObjectDocValuesLoader
        implements SourceLoader.SyntheticFieldLoader.DocValuesLoader {
            private final List<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders;

            private ObjectDocValuesLoader(List<SourceLoader.SyntheticFieldLoader.DocValuesLoader> loaders) {
                this.loaders = loaders;
            }

            @Override
            public boolean advanceToDoc(int docId) throws IOException {
                boolean anyLeafHasDocValues = false;
                for (SourceLoader.SyntheticFieldLoader.DocValuesLoader docValueLoader : this.loaders) {
                    boolean leafHasValue = docValueLoader.advanceToDoc(docId);
                    anyLeafHasDocValues |= leafHasValue;
                }
                SyntheticSourceFieldLoader.this.docValuesLoadersHaveValues = anyLeafHasDocValues;
                return anyLeafHasDocValues;
            }
        }

        static interface FieldWriter {
            public void writeTo(XContentBuilder var1) throws IOException;

            public boolean hasValue();

            public static class IgnoredSource
            implements FieldWriter {
                private final XContentParserConfiguration parserConfig;
                private final String fieldName;
                private final String leafName;
                private final List<BytesRef> encodedValues;

                IgnoredSource(SourceFilter filter, IgnoredSourceFieldMapper.NameValue initialValue) {
                    this.parserConfig = filter == null ? XContentParserConfiguration.EMPTY : XContentParserConfiguration.EMPTY.withFiltering(initialValue.name(), filter.getIncludes() != null ? Set.of(filter.getIncludes()) : null, filter.getExcludes() != null ? Set.of(filter.getExcludes()) : null, true);
                    this.fieldName = initialValue.name();
                    this.leafName = initialValue.getFieldName();
                    this.encodedValues = new ArrayList<BytesRef>();
                    if (initialValue.hasValue()) {
                        this.encodedValues.add(initialValue.value());
                    }
                }

                @Override
                public void writeTo(XContentBuilder builder) throws IOException {
                    XContentDataHelper.writeMerged(this.parserConfig, builder, this.leafName, this.encodedValues);
                }

                @Override
                public boolean hasValue() {
                    return !this.encodedValues.isEmpty();
                }

                public FieldWriter mergeWith(IgnoredSourceFieldMapper.NameValue nameValue) {
                    assert (Objects.equals(nameValue.name(), this.fieldName)) : "IgnoredSource is merged with wrong field data";
                    if (nameValue.hasValue()) {
                        this.encodedValues.add(nameValue.value());
                    }
                    return this;
                }
            }

            public record FieldLoader(SourceLoader.SyntheticFieldLoader loader) implements FieldWriter
            {
                @Override
                public void writeTo(XContentBuilder builder) throws IOException {
                    this.loader.write(builder);
                }

                @Override
                public boolean hasValue() {
                    return this.loader.hasValue();
                }
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public boolean supportsVersion(IndexVersion indexCreatedVersion) {
            return true;
        }

        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            parserContext.incrementMappingObjectDepth();
            Explicit<Subobjects> subobjects = TypeParser.parseSubobjects(node);
            Builder builder = new Builder(name, subobjects);
            TypeParser.parseObjectFields(node, parserContext, builder);
            parserContext.decrementMappingObjectDepth();
            return builder;
        }

        static void parseObjectFields(Map<String, Object> node, MappingParserContext parserContext, Builder builder) {
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Object fieldNode;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                if (!TypeParser.parseObjectOrDocumentTypeProperties(fieldName, fieldNode = entry.getValue(), parserContext, builder)) continue;
                iterator.remove();
            }
        }

        protected static boolean parseObjectOrDocumentTypeProperties(String fieldName, Object fieldNode, MappingParserContext parserContext, Builder builder) {
            if (fieldName.equals("dynamic")) {
                String value = fieldNode.toString();
                if (value.equalsIgnoreCase("strict")) {
                    builder.dynamic(Dynamic.STRICT);
                } else if (value.equalsIgnoreCase("runtime")) {
                    builder.dynamic(Dynamic.RUNTIME);
                } else {
                    boolean dynamic = XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".dynamic");
                    builder.dynamic(dynamic ? Dynamic.TRUE : Dynamic.FALSE);
                }
                return true;
            }
            if (fieldName.equals("enabled")) {
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode, fieldName + ".enabled"));
                return true;
            }
            if (fieldName.equals(ObjectMapper.STORE_ARRAY_SOURCE_PARAM)) {
                builder.sourceKeepMode(Mapper.SourceKeepMode.ARRAYS);
                return true;
            }
            if (fieldName.equals("synthetic_source_keep")) {
                builder.sourceKeepMode(Mapper.SourceKeepMode.from(fieldNode.toString()));
                return true;
            }
            if (fieldName.equals("properties")) {
                if (!(fieldNode instanceof Collection) || !((Collection)fieldNode).isEmpty()) {
                    if (!(fieldNode instanceof Map)) {
                        throw new ElasticsearchParseException("properties must be a map type", new Object[0]);
                    }
                    TypeParser.parseProperties(builder, (Map)fieldNode, parserContext);
                }
                return true;
            }
            if (fieldName.equals("include_in_all")) {
                deprecationLogger.warn(DeprecationCategory.MAPPINGS, "include_in_all", "[include_in_all] is deprecated, the _all field have been removed in this version", new Object[0]);
                return true;
            }
            return false;
        }

        protected static Explicit<Subobjects> parseSubobjects(Map<String, Object> node) {
            Object subobjectsNode = node.remove("subobjects");
            if (subobjectsNode != null) {
                return Explicit.of(Subobjects.from(subobjectsNode));
            }
            return Defaults.SUBOBJECTS;
        }

        protected static void parseProperties(Builder objBuilder, Map<String, Object> propsNode, MappingParserContext parserContext) {
            Iterator<Map.Entry<String, Object>> iterator = propsNode.entrySet().iterator();
            while (iterator.hasNext()) {
                boolean isEmptyList;
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                ObjectMapper.validateFieldName(fieldName, parserContext.indexVersionCreated());
                boolean bl = isEmptyList = entry.getValue() instanceof List && ((List)entry.getValue()).isEmpty();
                if (entry.getValue() instanceof Map) {
                    Mapper.Builder fieldBuilder;
                    String type;
                    Map propNode = (Map)entry.getValue();
                    Object typeNode = propNode.get("type");
                    if (typeNode != null) {
                        type = typeNode.toString();
                    } else if (propNode.get("properties") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else if (propNode.size() == 1 && propNode.get("enabled") != null) {
                        type = ObjectMapper.CONTENT_TYPE;
                    } else {
                        throw new MapperParsingException("No type specified for field [" + fieldName + "]");
                    }
                    if (objBuilder.subobjects.value() == Subobjects.DISABLED && type.equals("nested")) {
                        throw new MapperParsingException("Tried to add nested object [" + fieldName + "] to object [" + objBuilder.leafName() + "] which does not support subobjects");
                    }
                    Mapper.TypeParser typeParser = parserContext.typeParser(type);
                    if (typeParser == null) {
                        throw new MapperParsingException("The mapper type [" + type + "] declared on field [" + fieldName + "] does not exist. It might have been created within a future version or requires a plugin to be installed. Check the documentation.");
                    }
                    if (objBuilder.subobjects.value() != Subobjects.ENABLED) {
                        fieldBuilder = typeParser.parse(fieldName, propNode, parserContext);
                    } else {
                        String[] fieldNameParts = fieldName.split("\\.");
                        if (fieldNameParts.length == 0) {
                            throw new IllegalArgumentException("field name cannot contain only dots");
                        }
                        String realFieldName = fieldNameParts[fieldNameParts.length - 1];
                        ObjectMapper.validateFieldName(realFieldName, parserContext.indexVersionCreated());
                        fieldBuilder = typeParser.parse(realFieldName, propNode, parserContext);
                        for (int i = fieldNameParts.length - 2; i >= 0; --i) {
                            String intermediateObjectName = fieldNameParts[i];
                            ObjectMapper.validateFieldName(intermediateObjectName, parserContext.indexVersionCreated());
                            Builder intermediate = new Builder(intermediateObjectName, Defaults.SUBOBJECTS);
                            intermediate.add(fieldBuilder);
                            fieldBuilder = intermediate;
                        }
                    }
                    objBuilder.add(fieldBuilder);
                    propNode.remove("type");
                    MappingParser.checkNoRemainingFields(fieldName, propNode);
                    iterator.remove();
                    continue;
                }
                if (isEmptyList) {
                    iterator.remove();
                    continue;
                }
                throw new MapperParsingException("Expected map for property [fields] on field [" + fieldName + "] but got a " + String.valueOf(fieldName.getClass()));
            }
            MappingParser.checkNoRemainingFields(propsNode, "DocType mapping definition has unsupported parameters: ");
        }
    }
}

