/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.geo.Point;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.GeoPointScriptFieldData;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.CompositeFieldScript;
import org.elasticsearch.script.GeoPointFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.field.GeoPointDocValuesField;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.runtime.GeoPointScriptFieldDistanceFeatureQuery;
import org.elasticsearch.search.runtime.GeoPointScriptFieldExistsQuery;
import org.elasticsearch.search.runtime.GeoPointScriptFieldGeoShapeQuery;

public final class GeoPointScriptFieldType
extends AbstractScriptFieldType<GeoPointFieldScript.LeafFactory>
implements GeoShapeQueryable {
    public static final RuntimeField.Parser PARSER = new RuntimeField.Parser(name -> new AbstractScriptFieldType.Builder<GeoPointFieldScript.Factory>(name, GeoPointFieldScript.CONTEXT){

        @Override
        protected AbstractScriptFieldType<?> createFieldType(String name, GeoPointFieldScript.Factory factory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
            return new GeoPointScriptFieldType(name, factory, this.getScript(), this.meta(), onScriptError);
        }

        @Override
        protected GeoPointFieldScript.Factory getParseFromSourceFactory() {
            return GeoPointFieldScript.PARSE_FROM_SOURCE;
        }

        @Override
        protected GeoPointFieldScript.Factory getCompositeLeafFactory(Function<SearchLookup, CompositeFieldScript.LeafFactory> parentScriptFactory) {
            return GeoPointFieldScript.leafAdapter(parentScriptFactory);
        }
    });

    GeoPointScriptFieldType(String name, GeoPointFieldScript.Factory scriptFactory, Script script, Map<String, String> meta, OnScriptError onScriptError) {
        super(name, searchLookup -> scriptFactory.newFactory(name, script.getParams(), (SearchLookup)searchLookup, onScriptError), script, scriptFactory.isResultDeterministic(), meta, scriptFactory.isParsedFromSource());
    }

    @Override
    public String typeName() {
        return "geo_point";
    }

    @Override
    protected Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
        throw new IllegalArgumentException("Runtime field [" + this.name() + "] of type [" + this.typeName() + "] does not support range queries");
    }

    @Override
    public Query termQuery(Object value, SearchExecutionContext context) {
        throw new IllegalArgumentException("Geometry fields do not support exact searching, use dedicated geometry queries instead: [" + this.name() + "]");
    }

    @Override
    public GeoPointScriptFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
        return new GeoPointScriptFieldData.Builder(this.name(), (GeoPointFieldScript.LeafFactory)this.leafFactory(fieldDataContext.lookupSupplier().get()), GeoPointDocValuesField::new);
    }

    @Override
    public Query existsQuery(SearchExecutionContext context) {
        this.applyScriptContext(context);
        return new GeoPointScriptFieldExistsQuery(this.script, (GeoPointFieldScript.LeafFactory)this.leafFactory(context), this.name());
    }

    @Override
    public Query geoShapeQuery(SearchExecutionContext context, String fieldName, ShapeRelation relation, LatLonGeometry ... geometries) {
        if (relation == ShapeRelation.CONTAINS && Arrays.stream(geometries).anyMatch(g -> !(g instanceof Point))) {
            return new MatchNoDocsQuery();
        }
        return new GeoPointScriptFieldGeoShapeQuery(this.script, (GeoPointFieldScript.LeafFactory)this.leafFactory(context), fieldName, relation, geometries);
    }

    @Override
    public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
        GeoPoint originGeoPoint;
        if (origin instanceof GeoPoint) {
            originGeoPoint = (GeoPoint)origin;
        } else if (origin instanceof String) {
            originGeoPoint = GeoUtils.parseFromString((String)origin);
        } else {
            throw new IllegalArgumentException("Illegal type [" + String.valueOf(origin.getClass()) + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
        }
        double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
        return new GeoPointScriptFieldDistanceFeatureQuery(this.script, GeoPointScriptFieldType.valuesEncodedAsLong(context.lookup(), this.name(), ((GeoPointFieldScript.LeafFactory)this.leafFactory(context))::newInstance), this.name(), originGeoPoint.lat(), originGeoPoint.lon(), pivotDouble);
    }

    public static Function<LeafReaderContext, AbstractLongFieldScript> valuesEncodedAsLong(SearchLookup lookup, String name, Function<LeafReaderContext, GeoPointFieldScript> delegateLeafFactory) {
        return ctx -> {
            final GeoPointFieldScript script = (GeoPointFieldScript)delegateLeafFactory.apply((LeafReaderContext)ctx);
            return new AbstractLongFieldScript(name, Map.of(), lookup, OnScriptError.FAIL, (LeafReaderContext)ctx){
                private int docId;

                @Override
                protected void emitFromObject(Object v) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void setDocument(int docID) {
                    super.setDocument(docID);
                    this.docId = docID;
                }

                @Override
                public void execute() {
                    script.runForDoc(this.docId);
                    for (int i = 0; i < script.count(); ++i) {
                        int latitudeEncoded = GeoEncodingUtils.encodeLatitude((double)script.lats()[i]);
                        int longitudeEncoded = GeoEncodingUtils.encodeLongitude((double)script.lons()[i]);
                        this.emit((long)latitudeEncoded << 32 | (long)longitudeEncoded & 0xFFFFFFFFL);
                    }
                }
            };
        };
    }

    @Override
    public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
        final GeoPointFieldScript.LeafFactory leafFactory = (GeoPointFieldScript.LeafFactory)this.leafFactory(context.lookup());
        final Function<List<GeoPoint>, List<Object>> formatter = GeoPointFieldMapper.GeoPointFieldType.GEO_FORMATTER_FACTORY.getFormatter(format != null ? format : "geojson", p -> new org.elasticsearch.geometry.Point(p.getLon(), p.getLat()));
        return new ValueFetcher(){
            private GeoPointFieldScript script;

            @Override
            public void setNextReader(LeafReaderContext context) {
                this.script = leafFactory.newInstance(context);
            }

            @Override
            public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
                this.script.runForDoc(doc);
                if (this.script.count() == 0) {
                    return List.of();
                }
                ArrayList<GeoPoint> points = new ArrayList<GeoPoint>(this.script.count());
                for (int i = 0; i < this.script.count(); ++i) {
                    points.add(new GeoPoint(this.script.lats()[i], this.script.lons()[i]));
                }
                return (List)formatter.apply(points);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NEEDS_SOURCE;
            }
        };
    }
}

