/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.lookup.Source;

public final class DocValueFetcher
implements ValueFetcher {
    private final DocValueFormat format;
    private final IndexFieldData<?> ifd;
    private FormattedDocValues formattedDocValues;
    private final StoredFieldsSpec storedFieldsSpec;

    public DocValueFetcher(DocValueFormat format, IndexFieldData<?> ifd, StoredFieldsSpec storedFieldsSpec) {
        this.format = format;
        this.ifd = ifd;
        this.storedFieldsSpec = storedFieldsSpec;
    }

    public DocValueFetcher(DocValueFormat format, IndexFieldData<?> ifd) {
        this(format, ifd, StoredFieldsSpec.NO_REQUIREMENTS);
    }

    @Override
    public void setNextReader(LeafReaderContext context) {
        this.formattedDocValues = this.ifd.load(context).getFormattedValues(this.format);
    }

    @Override
    public List<Object> fetchValues(Source source, int doc, List<Object> ignoredValues) throws IOException {
        if (!this.formattedDocValues.advanceExact(doc)) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>(this.formattedDocValues.docValueCount());
        int count = this.formattedDocValues.docValueCount();
        for (int i = 0; i < count; ++i) {
            result.add(this.formattedDocValues.nextValue());
        }
        return result;
    }

    @Override
    public StoredFieldsSpec storedFieldsSpec() {
        return this.storedFieldsSpec;
    }
}

