/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fieldvisitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.FallbackSyntheticSourceBlockLoader;
import org.elasticsearch.index.mapper.IgnoredSourceFieldMapper;
import org.elasticsearch.search.fetch.StoredFieldsSpec;

class IgnoredSourceFieldLoader
extends StoredFieldLoader {
    private final boolean forceSequentialReader;
    private final Map<String, Set<String>> potentialFieldsInIgnoreSource;
    private final Set<String> fieldNames;

    IgnoredSourceFieldLoader(StoredFieldsSpec spec, boolean forceSequentialReader) {
        assert (IgnoredSourceFieldLoader.supports(spec));
        this.fieldNames = new HashSet<String>(spec.ignoredFieldsSpec().requiredIgnoredFields());
        this.forceSequentialReader = forceSequentialReader;
        HashMap<String, Set<String>> potentialFieldsInIgnoreSource = new HashMap<String, Set<String>>();
        for (String requiredIgnoredField : spec.ignoredFieldsSpec().requiredIgnoredFields()) {
            for (String potentialIgnoredField : FallbackSyntheticSourceBlockLoader.splitIntoFieldPaths(requiredIgnoredField)) {
                potentialFieldsInIgnoreSource.computeIfAbsent(potentialIgnoredField, k -> new HashSet()).add(requiredIgnoredField);
            }
        }
        this.potentialFieldsInIgnoreSource = potentialFieldsInIgnoreSource;
    }

    @Override
    public LeafStoredFieldLoader getLoader(LeafReaderContext ctx, int[] docs) throws IOException {
        final CheckedBiConsumer<Integer, StoredFieldVisitor, IOException> reader = this.forceSequentialReader ? IgnoredSourceFieldLoader.sequentialReader(ctx) : IgnoredSourceFieldLoader.reader(ctx, docs);
        final SFV visitor = new SFV(this.fieldNames, this.potentialFieldsInIgnoreSource);
        return new LeafStoredFieldLoader(){
            private int doc = -1;

            @Override
            public void advanceTo(int doc) throws IOException {
                if (doc != this.doc) {
                    visitor.reset();
                    reader.accept(doc, visitor);
                    this.doc = doc;
                }
            }

            @Override
            public BytesReference source() {
                assert (false) : "source() is not supported by IgnoredSourceFieldLoader";
                return null;
            }

            @Override
            public String id() {
                assert (false) : "id() is not supported by IgnoredSourceFieldLoader";
                return null;
            }

            @Override
            public String routing() {
                assert (false) : "routing() is not supported by IgnoredSourceFieldLoader";
                return null;
            }

            @Override
            public Map<String, List<Object>> storedFields() {
                return Map.of("_ignored_source", Collections.unmodifiableList(visitor.values));
            }
        };
    }

    @Override
    public List<String> fieldsToLoad() {
        return this.potentialFieldsInIgnoreSource.keySet().stream().toList();
    }

    static boolean supports(StoredFieldsSpec spec) {
        return spec.onlyRequiresIgnoredFields() && spec.ignoredFieldsSpec().format() == IgnoredSourceFieldMapper.IgnoredSourceFormat.COALESCED_SINGLE_IGNORED_SOURCE;
    }

    static class SFV
    extends StoredFieldVisitor {
        List<List<IgnoredSourceFieldMapper.NameValue>> values = new ArrayList<List<IgnoredSourceFieldMapper.NameValue>>();
        final Set<String> fieldNames;
        private final Set<String> unvisitedFields;
        final Map<String, Set<String>> potentialFieldsInIgnoreSource;

        SFV(Set<String> fieldNames, Map<String, Set<String>> potentialFieldsInIgnoreSource) {
            this.fieldNames = fieldNames;
            this.unvisitedFields = new HashSet<String>(fieldNames);
            this.potentialFieldsInIgnoreSource = potentialFieldsInIgnoreSource;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if (this.unvisitedFields.isEmpty()) {
                return StoredFieldVisitor.Status.STOP;
            }
            if (fieldInfo.name.equals("_ignored_source")) {
                return StoredFieldVisitor.Status.YES;
            }
            return StoredFieldVisitor.Status.NO;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) {
            List<IgnoredSourceFieldMapper.NameValue> nameValues = IgnoredSourceFieldMapper.CoalescedIgnoredSourceEncoding.decode(new BytesRef(value));
            assert (!nameValues.isEmpty());
            String fieldPath = nameValues.getFirst().name();
            Set<String> foundValues = this.potentialFieldsInIgnoreSource.get(fieldPath);
            if (foundValues == null) {
                return;
            }
            this.unvisitedFields.removeAll(foundValues);
            this.values.add(nameValues);
        }

        void reset() {
            this.values.clear();
            this.unvisitedFields.addAll(this.fieldNames);
        }
    }
}

