/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.cluster;

import org.apache.lucene.util.LongHeap;
import org.apache.lucene.util.NumericUtils;

public class NeighborQueue {
    private final LongHeap heap;
    private final Order order;

    public NeighborQueue(int initialSize, boolean maxHeap) {
        this.heap = new LongHeap(initialSize);
        this.order = maxHeap ? Order.MAX_HEAP : Order.MIN_HEAP;
    }

    public int size() {
        return this.heap.size();
    }

    public long peek() {
        return this.heap.top();
    }

    public void add(int newNode, float newScore) {
        this.heap.push(this.encode(newNode, newScore));
    }

    public boolean insertWithOverflow(int newNode, float newScore) {
        return this.heap.insertWithOverflow(this.encode(newNode, newScore));
    }

    public boolean insertWithOverflow(long encoded) {
        return this.heap.insertWithOverflow(encoded);
    }

    public long encode(int node, float score) {
        return this.order.apply(NeighborQueue.encodeRaw(node, score));
    }

    public int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    public static long encodeRaw(int node, float score) {
        return (long)NumericUtils.floatToSortableInt((float)score) << 32 | 0xFFFFFFFFL & (long)(~node);
    }

    public static float decodeScoreRaw(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)((int)(heapValue >> 32)));
    }

    public float topScore() {
        return this.decodeScore(this.heap.top());
    }

    public float decodeScore(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)((int)(this.order.apply(heapValue) >> 32)));
    }

    private int decodeNodeId(long heapValue) {
        return (int)(this.order.apply(heapValue) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    public long popRaw() {
        return this.heap.pop();
    }

    public int popAndAddRaw(long raw) {
        long top = this.heap.top();
        if (raw < top) {
            return this.decodeNodeId(raw);
        }
        this.heap.updateTop(raw);
        return this.decodeNodeId(top);
    }

    public void clear() {
        this.heap.clear();
    }

    public String toString() {
        return "Neighbors[" + this.heap.size() + "]";
    }

    private static enum Order {
        MIN_HEAP{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        MAX_HEAP{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }
}

