/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.IntArray;

class ReleasableIntArray
implements IntArray {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReleasableIntArray.class);
    private final ReleasableBytesReference ref;

    ReleasableIntArray(StreamInput in) throws IOException {
        this.ref = in.readReleasableBytesReference();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.ref);
    }

    @Override
    public long size() {
        return this.ref.length() / 4;
    }

    @Override
    public int get(long index) {
        if (index > 0x1FFFFFFFL) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.ref.getIntLE((int)index * 4);
    }

    @Override
    public int getAndSet(long index, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int increment(long index, int inc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fill(long fromIndex, long toIndex, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        throw new UnsupportedOperationException();
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE;
    }

    public void close() {
        this.ref.decRef();
    }
}

