/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.time.DateTimeParser;
import org.elasticsearch.common.time.DecimalSeparator;
import org.elasticsearch.common.time.Iso8601Parser;
import org.elasticsearch.common.time.ParseResult;
import org.elasticsearch.common.time.TimezonePresence;

class Iso8601DateTimeParser
implements DateTimeParser {
    private final Iso8601Parser parser;
    private final ZoneId timezone;
    private final Locale locale;

    Iso8601DateTimeParser(Set<ChronoField> mandatoryFields, boolean optionalTime, ChronoField maxAllowedField, DecimalSeparator decimalSeparator, TimezonePresence timezonePresence) {
        this.parser = new Iso8601Parser(mandatoryFields, optionalTime, maxAllowedField, decimalSeparator, timezonePresence, Map.of());
        this.timezone = null;
        this.locale = null;
    }

    private Iso8601DateTimeParser(Iso8601Parser parser, ZoneId timezone, Locale locale) {
        this.parser = parser;
        this.timezone = timezone;
        this.locale = locale;
    }

    @Override
    public ZoneId getZone() {
        return this.timezone;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public DateTimeParser withZone(ZoneId zone) {
        return new Iso8601DateTimeParser(this.parser, zone, this.locale);
    }

    @Override
    public DateTimeParser withLocale(Locale locale) {
        return new Iso8601DateTimeParser(this.parser, this.timezone, locale);
    }

    Iso8601DateTimeParser withDefaults(Map<ChronoField, Integer> defaults) {
        return new Iso8601DateTimeParser(new Iso8601Parser(this.parser.mandatoryFields(), this.parser.optionalTime(), this.parser.maxAllowedField(), this.parser.decimalSeparator(), this.parser.timezonePresence(), defaults), this.timezone, this.locale);
    }

    @Override
    public TemporalAccessor parse(CharSequence str) {
        ParseResult result = this.parser.tryParse(str, this.timezone);
        TemporalAccessor temporal = result.result();
        if (temporal == null) {
            throw new DateTimeParseException("Could not fully parse datetime", str, result.errorIndex());
        }
        return temporal;
    }

    @Override
    public ParseResult tryParse(CharSequence str) {
        return this.parser.tryParse(str, this.timezone);
    }
}

