/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public enum Orientation {
    LEFT,
    RIGHT;

    public static final Orientation CLOCKWISE;
    public static final Orientation COUNTER_CLOCKWISE;
    public static final Orientation CW;
    public static final Orientation CCW;

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this == RIGHT);
    }

    public static Orientation readFrom(StreamInput in) throws IOException {
        return in.readBoolean() ? RIGHT : LEFT;
    }

    public boolean getAsBoolean() {
        return this == RIGHT;
    }

    public static Orientation fromString(String orientation) {
        return switch (orientation = orientation.toLowerCase(Locale.ROOT)) {
            case "right", "counterclockwise", "ccw" -> RIGHT;
            case "left", "clockwise", "cw" -> LEFT;
            default -> throw new IllegalArgumentException("Unknown orientation [" + orientation + "]");
        };
    }

    static {
        CLOCKWISE = LEFT;
        COUNTER_CLOCKWISE = RIGHT;
        CW = LEFT;
        CCW = RIGHT;
    }
}

