/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.cli;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import joptsimple.OptionSet;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;

public abstract class KeyStoreAwareCommand
extends EnvironmentAwareCommand {
    public KeyStoreAwareCommand(String description) {
        super(description);
    }

    protected static SecureString readPassword(Terminal terminal, boolean withVerification) throws UserException {
        char[] passwordArray;
        if (withVerification) {
            char[] passwordVerification;
            passwordArray = terminal.readSecret("Enter new password for the elasticsearch keystore (empty for no password): ");
            if (!Arrays.equals(passwordArray, passwordVerification = terminal.readSecret("Enter same password again: "))) {
                throw new UserException(65, "Passwords are not equal, exiting.: " + new String(passwordArray) + ", " + new String(passwordVerification));
            }
            Arrays.fill(passwordVerification, '\u0000');
        } else {
            passwordArray = terminal.readSecret("Enter password for the elasticsearch keystore : ");
        }
        return new SecureString(passwordArray);
    }

    protected static void decryptKeyStore(KeyStoreWrapper keyStore, Terminal terminal) throws UserException, IOException {
        try (SecureString keystorePassword = keyStore.hasPassword() ? KeyStoreAwareCommand.readPassword(terminal, false) : new SecureString(new char[0]);){
            keyStore.decrypt(keystorePassword.getChars());
        }
        catch (SecurityException | GeneralSecurityException e) {
            throw new UserException(65, e.getMessage());
        }
    }

    @Override
    public abstract void execute(Terminal var1, OptionSet var2, Environment var3, ProcessInfo var4) throws Exception;
}

