/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.blobstore;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record BlobStoreActionStats(long operations, long requests) implements Writeable,
ToXContentObject
{
    public static final BlobStoreActionStats ZERO = new BlobStoreActionStats(0L, 0L);

    public BlobStoreActionStats(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong());
    }

    public BlobStoreActionStats {
        assert (operations >= 0L && requests >= 0L) : "Requests (" + requests + ") and operations (" + operations + ") must be non-negative";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.operations);
        out.writeVLong(this.requests);
    }

    public BlobStoreActionStats add(BlobStoreActionStats other) {
        return new BlobStoreActionStats(Math.addExact(this.operations, other.operations), Math.addExact(this.requests, other.requests));
    }

    public boolean isZero() {
        return this.operations == 0L && this.requests == 0L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("operations", this.operations);
        builder.field("requests", this.requests);
        builder.endObject();
        return builder;
    }
}

