/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStatsAndWeightsCalculator;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationBalancingRoundSummaryService;
import org.elasticsearch.cluster.routing.allocation.allocator.ContinuousComputation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceComputer;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceInput;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceReconciler;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceStats;
import org.elasticsearch.cluster.routing.allocation.allocator.PendingListenersQueue;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.threadpool.ThreadPool;

public class DesiredBalanceShardsAllocator
implements ShardsAllocator {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceShardsAllocator.class);
    private final ShardsAllocator delegateAllocator;
    private final ThreadPool threadPool;
    private final DesiredBalanceReconcilerAction reconciler;
    private final DesiredBalanceComputer desiredBalanceComputer;
    private final DesiredBalanceReconciler desiredBalanceReconciler;
    private final ContinuousComputation<DesiredBalanceInput> desiredBalanceComputation;
    private final PendingListenersQueue pendingListenersQueue;
    private final AtomicLong indexGenerator = new AtomicLong(-1L);
    private final ConcurrentLinkedQueue<List<MoveAllocationCommand>> pendingDesiredBalanceMoves = new ConcurrentLinkedQueue();
    private final MasterServiceTaskQueue<ReconcileDesiredBalanceTask> masterServiceTaskQueue;
    private final AtomicReference<DesiredBalance> currentDesiredBalanceRef = new AtomicReference<DesiredBalance>(DesiredBalance.NOT_MASTER);
    private volatile boolean resetCurrentDesiredBalance = false;
    private final Set<String> processedNodeShutdowns = new HashSet<String>();
    private final NodeAllocationStatsAndWeightsCalculator nodeAllocationStatsAndWeightsCalculator;
    private final DesiredBalanceMetrics desiredBalanceMetrics;
    private final AllocationBalancingRoundSummaryService balancerRoundSummaryService;
    protected final CounterMetric computationsSubmitted = new CounterMetric();
    protected final CounterMetric computationsExecuted = new CounterMetric();
    protected final CounterMetric computationsConverged = new CounterMetric();
    protected final MeanMetric computedShardMovements = new MeanMetric();
    protected final CounterMetric cumulativeComputationTime = new CounterMetric();
    protected final CounterMetric cumulativeReconciliationTime = new CounterMetric();
    private static final Runnable NEVER_CANCELLED = () -> {};

    public DesiredBalanceShardsAllocator(ClusterSettings clusterSettings, ShardsAllocator delegateAllocator, ThreadPool threadPool, ClusterService clusterService, DesiredBalanceReconcilerAction reconciler, NodeAllocationStatsAndWeightsCalculator nodeAllocationStatsAndWeightsCalculator, ShardAllocationExplainer shardAllocationExplainer, DesiredBalanceMetrics desiredBalanceMetrics) {
        this(delegateAllocator, threadPool, clusterService, new DesiredBalanceComputer(clusterSettings, threadPool, delegateAllocator, shardAllocationExplainer), reconciler, nodeAllocationStatsAndWeightsCalculator, desiredBalanceMetrics);
    }

    public DesiredBalanceShardsAllocator(ShardsAllocator delegateAllocator, ThreadPool threadPool, ClusterService clusterService, final DesiredBalanceComputer desiredBalanceComputer, DesiredBalanceReconcilerAction reconciler, NodeAllocationStatsAndWeightsCalculator nodeAllocationStatsAndWeightsCalculator, DesiredBalanceMetrics desiredBalanceMetrics) {
        this.desiredBalanceMetrics = desiredBalanceMetrics;
        this.nodeAllocationStatsAndWeightsCalculator = nodeAllocationStatsAndWeightsCalculator;
        this.balancerRoundSummaryService = new AllocationBalancingRoundSummaryService(threadPool, clusterService.getClusterSettings());
        this.delegateAllocator = delegateAllocator;
        this.threadPool = threadPool;
        this.reconciler = reconciler;
        this.desiredBalanceComputer = desiredBalanceComputer;
        this.desiredBalanceReconciler = new DesiredBalanceReconciler(clusterService.getClusterSettings(), threadPool);
        this.desiredBalanceComputation = new ContinuousComputation<DesiredBalanceInput>((Executor)threadPool.generic()){

            @Override
            protected void processInput(DesiredBalanceInput desiredBalanceInput) {
                DesiredBalanceShardsAllocator.this.processNodeShutdowns(desiredBalanceInput.routingAllocation().getClusterState());
                long index = desiredBalanceInput.index();
                logger.debug("Starting desired balance computation for [{}]", (Object)index);
                DesiredBalance initialDesiredBalance = this.getInitialDesiredBalance();
                if (initialDesiredBalance == DesiredBalance.NOT_MASTER) {
                    logger.debug("Abort desired balance computation because node is no longer master");
                    return;
                }
                DesiredBalanceShardsAllocator.this.recordTime(DesiredBalanceShardsAllocator.this.cumulativeComputationTime, () -> DesiredBalanceShardsAllocator.this.setCurrentDesiredBalance(desiredBalanceComputer.compute(initialDesiredBalance, desiredBalanceInput, DesiredBalanceShardsAllocator.this.pendingDesiredBalanceMoves, this::isFresh)));
                DesiredBalanceShardsAllocator.this.computationsExecuted.inc();
                DesiredBalance currentDesiredBalance = DesiredBalanceShardsAllocator.this.currentDesiredBalanceRef.get();
                if (currentDesiredBalance == DesiredBalance.NOT_MASTER || currentDesiredBalance == DesiredBalance.BECOME_MASTER_INITIAL) {
                    logger.debug(() -> Strings.format("Desired balance computation for [%s] is discarded since master has concurrently changed. Current desiredBalance=[%s]", index, currentDesiredBalance));
                } else if (currentDesiredBalance.finishReason() == DesiredBalance.ComputationFinishReason.STOP_EARLY) {
                    logger.debug("Desired balance computation for [{}] terminated early with partial result, scheduling reconciliation", (Object)index);
                    DesiredBalanceShardsAllocator.this.submitReconcileTask(currentDesiredBalance);
                    DesiredBalanceInput newInput = DesiredBalanceInput.create(DesiredBalanceShardsAllocator.this.indexGenerator.incrementAndGet(), desiredBalanceInput.routingAllocation());
                    DesiredBalanceShardsAllocator.this.desiredBalanceComputation.compareAndEnqueue(desiredBalanceInput, newInput);
                } else if (this.isFresh(desiredBalanceInput)) {
                    logger.debug("Desired balance computation for [{}] is completed, scheduling reconciliation", (Object)index);
                    DesiredBalanceShardsAllocator.this.computationsConverged.inc();
                    DesiredBalanceShardsAllocator.this.submitReconcileTask(currentDesiredBalance);
                } else {
                    logger.debug("Desired balance computation for [{}] is discarded as newer one is submitted", (Object)index);
                }
            }

            private DesiredBalance getInitialDesiredBalance() {
                DesiredBalance currentDesiredBalance = DesiredBalanceShardsAllocator.this.currentDesiredBalanceRef.get();
                if (DesiredBalanceShardsAllocator.this.resetCurrentDesiredBalance) {
                    logger.info("Resetting current desired balance");
                    DesiredBalanceShardsAllocator.this.resetCurrentDesiredBalance = false;
                    return currentDesiredBalance == DesiredBalance.NOT_MASTER ? DesiredBalance.NOT_MASTER : new DesiredBalance(currentDesiredBalance.lastConvergedIndex(), Map.of());
                }
                return currentDesiredBalance;
            }

            public String toString() {
                return "DesiredBalanceShardsAllocator#allocate";
            }
        };
        this.pendingListenersQueue = new PendingListenersQueue();
        this.masterServiceTaskQueue = clusterService.createTaskQueue("reconcile-desired-balance", Priority.URGENT, new ReconcileDesiredBalanceExecutor());
        clusterService.addListener(event -> {
            if (!event.localNodeMaster()) {
                this.onNoLongerMaster();
            }
            if (event.localNodeMaster() != event.previousState().nodes().isLocalNodeElectedMaster()) {
                desiredBalanceMetrics.setNodeIsMaster(event.localNodeMaster());
            }
        });
    }

    @Override
    public ShardAllocationDecision decideShardAllocation(ShardRouting shard, RoutingAllocation allocation) {
        return this.delegateAllocator.decideShardAllocation(shard, allocation);
    }

    @Override
    public void allocate(RoutingAllocation allocation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void allocate(RoutingAllocation allocation, ActionListener<Void> listener) {
        assert (MasterService.assertMasterUpdateOrTestThread()) : Thread.currentThread().getName();
        assert (!allocation.ignoreDisable());
        this.computationsSubmitted.inc();
        long index = this.indexGenerator.incrementAndGet();
        logger.debug("Executing allocate for [{}]", (Object)index);
        this.pendingListenersQueue.add(index, listener);
        if (this.currentDesiredBalanceRef.compareAndSet(DesiredBalance.NOT_MASTER, DesiredBalance.BECOME_MASTER_INITIAL)) {
            logger.debug("initialized desired balance for becoming master");
        }
        this.desiredBalanceComputation.onNewInput(DesiredBalanceInput.create(index, allocation));
        if (!allocation.globalRoutingTable().hasIndices()) {
            logger.debug("No eager reconciliation needed for empty routing table");
            return;
        }
        this.reconcile(this.currentDesiredBalanceRef.get(), allocation);
    }

    private void processNodeShutdowns(ClusterState clusterState) {
        DiscoveryNodes nodes = clusterState.nodes();
        NodesShutdownMetadata nodeShutdowns = clusterState.metadata().nodeShutdowns();
        boolean reset = this.processedNodeShutdowns.stream().anyMatch(nodeId -> !nodeShutdowns.contains((String)nodeId) && nodes.get((String)nodeId) != null);
        this.processedNodeShutdowns.removeIf(nodeId -> !nodeShutdowns.contains((String)nodeId));
        for (Map.Entry<String, SingleNodeShutdownMetadata> shutdown : nodeShutdowns.getAll().entrySet()) {
            if (shutdown.getValue().getType() == SingleNodeShutdownMetadata.Type.RESTART) continue;
            reset |= this.processedNodeShutdowns.add(shutdown.getKey());
        }
        if (reset) {
            this.resetDesiredBalance();
        }
    }

    @Override
    public RoutingExplanations execute(RoutingAllocation allocation, AllocationCommands commands, boolean explain, boolean retryFailed) {
        RoutingExplanations explanations = ShardsAllocator.super.execute(allocation, commands, explain, retryFailed);
        List<MoveAllocationCommand> moves = DesiredBalanceShardsAllocator.getMoveCommands(commands);
        if (!moves.isEmpty()) {
            this.pendingDesiredBalanceMoves.add(moves);
        }
        return explanations;
    }

    private static List<MoveAllocationCommand> getMoveCommands(AllocationCommands commands) {
        ArrayList<MoveAllocationCommand> moves = new ArrayList<MoveAllocationCommand>();
        for (AllocationCommand command : commands.commands()) {
            if (!(command instanceof MoveAllocationCommand)) continue;
            MoveAllocationCommand move = (MoveAllocationCommand)command;
            moves.add(move);
        }
        return moves;
    }

    private void setCurrentDesiredBalance(DesiredBalance newDesiredBalance) {
        DesiredBalance oldDesiredBalance;
        do {
            if ((oldDesiredBalance = this.currentDesiredBalanceRef.get()) != DesiredBalance.NOT_MASTER) continue;
            logger.debug("discard desired balance for [{}] since node is no longer master", (Object)newDesiredBalance.lastConvergedIndex());
            return;
        } while (!this.currentDesiredBalanceRef.compareAndSet(oldDesiredBalance, newDesiredBalance));
        this.balancerRoundSummaryService.addBalancerRoundSummary(oldDesiredBalance, newDesiredBalance);
        if (logger.isTraceEnabled()) {
            String diff = DesiredBalance.hasChanges(oldDesiredBalance, newDesiredBalance) ? "Diff: " + DesiredBalance.humanReadableDiff(oldDesiredBalance, newDesiredBalance) : "No changes";
            logger.trace("Desired balance updated: {}. {}", (Object)newDesiredBalance, (Object)diff);
        } else {
            logger.debug("Desired balance updated for [{}]", (Object)newDesiredBalance.lastConvergedIndex());
        }
        this.computedShardMovements.inc(DesiredBalance.shardMovements(oldDesiredBalance, newDesiredBalance));
    }

    protected void submitReconcileTask(DesiredBalance desiredBalance) {
        this.masterServiceTaskQueue.submitTask("reconcile-desired-balance", new ReconcileDesiredBalanceTask(desiredBalance), null);
    }

    protected void reconcile(DesiredBalance desiredBalance, RoutingAllocation allocation) {
        if (logger.isTraceEnabled()) {
            logger.trace("Reconciling desired balance: {}", (Object)desiredBalance);
        } else {
            logger.debug("Reconciling desired balance for [{}]", (Object)desiredBalance.lastConvergedIndex());
        }
        this.recordTime(this.cumulativeReconciliationTime, () -> {
            DesiredBalanceMetrics.AllocationStats allocationStats = this.desiredBalanceReconciler.reconcile(desiredBalance, allocation);
            this.updateDesireBalanceMetrics(desiredBalance, allocation, allocationStats);
        });
        if (logger.isTraceEnabled()) {
            logger.trace("Reconciled desired balance: {}", (Object)desiredBalance);
        } else {
            logger.debug("Reconciled desired balance for [{}]", (Object)desiredBalance.lastConvergedIndex());
        }
    }

    private AllocationService.RerouteStrategy createReconcileAllocationAction(final DesiredBalance desiredBalance) {
        return new AllocationService.RerouteStrategy(){

            @Override
            public void removeDelayMarkers(RoutingAllocation allocation) {
            }

            @Override
            public void execute(RoutingAllocation allocation) {
                DesiredBalanceShardsAllocator.this.reconcile(desiredBalance, allocation);
            }
        };
    }

    public DesiredBalance getDesiredBalance() {
        return this.currentDesiredBalanceRef.get();
    }

    public void resetDesiredBalance() {
        this.resetCurrentDesiredBalance = true;
    }

    private void updateDesireBalanceMetrics(DesiredBalance desiredBalance, RoutingAllocation routingAllocation, DesiredBalanceMetrics.AllocationStats allocationStats) {
        Map<String, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> nodesStatsAndWeights = this.nodeAllocationStatsAndWeightsCalculator.nodesAllocationStatsAndWeights(routingAllocation.metadata(), routingAllocation.routingNodes(), routingAllocation.clusterInfo(), NEVER_CANCELLED, desiredBalance);
        HashMap<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> filteredNodeAllocationStatsAndWeights = new HashMap<DiscoveryNode, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight>(nodesStatsAndWeights.size());
        for (Map.Entry<String, NodeAllocationStatsAndWeightsCalculator.NodeAllocationStatsAndWeight> nodeStatsAndWeight : nodesStatsAndWeights.entrySet()) {
            DiscoveryNode node = routingAllocation.nodes().get(nodeStatsAndWeight.getKey());
            if (node == null) continue;
            filteredNodeAllocationStatsAndWeights.put(node, nodeStatsAndWeight.getValue());
        }
        this.desiredBalanceMetrics.updateMetrics(allocationStats, desiredBalance.weightsPerNode(), filteredNodeAllocationStatsAndWeights);
    }

    public DesiredBalanceStats getStats() {
        return new DesiredBalanceStats(Math.max(this.currentDesiredBalanceRef.get().lastConvergedIndex(), 0L), this.desiredBalanceComputation.isActive(), this.computationsSubmitted.count(), this.computationsExecuted.count(), this.computationsConverged.count(), this.desiredBalanceComputer.iterations.sum(), this.computedShardMovements.sum(), this.cumulativeComputationTime.count(), this.cumulativeReconciliationTime.count(), this.desiredBalanceMetrics.unassignedShards(), this.desiredBalanceMetrics.totalAllocations(), this.desiredBalanceMetrics.undesiredAllocations());
    }

    public DesiredBalanceMetrics.AllocationStats getAllocationStats() {
        return this.desiredBalanceMetrics.allocationStats();
    }

    private void onNoLongerMaster() {
        if (this.indexGenerator.getAndSet(-1L) != -1L) {
            this.currentDesiredBalanceRef.set(DesiredBalance.NOT_MASTER);
            this.pendingListenersQueue.completeAllAsNotMaster();
            this.pendingDesiredBalanceMoves.clear();
            this.desiredBalanceReconciler.clear();
            this.desiredBalanceMetrics.zeroAllMetrics();
        }
    }

    protected final void completeToLastConvergedIndex() {
        this.pendingListenersQueue.complete(this.currentDesiredBalanceRef.get().lastConvergedIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordTime(CounterMetric metric, Runnable action) {
        long started = this.threadPool.relativeTimeInMillis();
        try {
            action.run();
        }
        finally {
            long finished = this.threadPool.relativeTimeInMillis();
            metric.inc(finished - started);
        }
    }

    Set<String> getProcessedNodeShutdowns() {
        return Set.copyOf(this.processedNodeShutdowns);
    }

    @FunctionalInterface
    public static interface ShardAllocationExplainer {
        public ShardAllocationDecision explain(ShardRouting var1, RoutingAllocation var2);
    }

    @FunctionalInterface
    public static interface DesiredBalanceReconcilerAction {
        public ClusterState apply(ClusterState var1, AllocationService.RerouteStrategy var2);
    }

    private final class ReconcileDesiredBalanceExecutor
    implements ClusterStateTaskExecutor<ReconcileDesiredBalanceTask> {
        private ReconcileDesiredBalanceExecutor() {
        }

        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<ReconcileDesiredBalanceTask> batchExecutionContext) {
            ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest = ReconcileDesiredBalanceExecutor.findLatest(batchExecutionContext.taskContexts());
            ClusterState newState = this.applyBalance(batchExecutionContext, latest);
            ReconcileDesiredBalanceExecutor.discardSupersededTasks(batchExecutionContext.taskContexts(), latest);
            return newState;
        }

        private static ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> findLatest(List<? extends ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask>> taskContexts) {
            return taskContexts.stream().max(Comparator.comparing(context -> ((ReconcileDesiredBalanceTask)context.getTask()).desiredBalance.lastConvergedIndex())).get();
        }

        private ClusterState applyBalance(ClusterStateTaskExecutor.BatchExecutionContext<ReconcileDesiredBalanceTask> batchExecutionContext, ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest) {
            try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                ClusterState newState = DesiredBalanceShardsAllocator.this.reconciler.apply(batchExecutionContext.initialState(), DesiredBalanceShardsAllocator.this.createReconcileAllocationAction(latest.getTask().desiredBalance));
                latest.success(() -> DesiredBalanceShardsAllocator.this.pendingListenersQueue.complete(((ReconcileDesiredBalanceTask)latest.getTask()).desiredBalance.lastConvergedIndex()));
                ClusterState clusterState = newState;
                return clusterState;
            }
        }

        private static void discardSupersededTasks(List<? extends ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask>> taskContexts, ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> latest) {
            for (ClusterStateTaskExecutor.TaskContext<ReconcileDesiredBalanceTask> taskContext : taskContexts) {
                if (taskContext == latest) continue;
                taskContext.success(() -> {});
            }
        }
    }

    private static final class ReconcileDesiredBalanceTask
    implements ClusterStateTaskListener {
        private final DesiredBalance desiredBalance;

        private ReconcileDesiredBalanceTask(DesiredBalance desiredBalance) {
            this.desiredBalance = desiredBalance;
        }

        @Override
        public void onFailure(Exception e) {
            assert (MasterService.isPublishFailureException(e)) : e;
        }

        public String toString() {
            return "ReconcileDesiredBalanceTask[lastConvergedIndex=" + this.desiredBalance.lastConvergedIndex() + "]";
        }
    }
}

