/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class AbstractAllocationDecision
implements ChunkedToXContentObject,
Writeable {
    @Nullable
    protected final DiscoveryNode targetNode;
    @Nullable
    protected final List<NodeAllocationResult> nodeDecisions;

    protected AbstractAllocationDecision(@Nullable DiscoveryNode targetNode, @Nullable List<NodeAllocationResult> nodeDecisions) {
        this.targetNode = targetNode;
        this.nodeDecisions = nodeDecisions != null ? AbstractAllocationDecision.sortNodeDecisions(nodeDecisions) : null;
    }

    protected AbstractAllocationDecision(StreamInput in) throws IOException {
        this.targetNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.nodeDecisions = in.readBoolean() ? in.readCollectionAsImmutableList(NodeAllocationResult::new) : null;
    }

    public abstract boolean isDecisionTaken();

    @Nullable
    public DiscoveryNode getTargetNode() {
        this.checkDecisionState();
        return this.targetNode;
    }

    @Nullable
    public List<NodeAllocationResult> getNodeDecisions() {
        this.checkDecisionState();
        return this.nodeDecisions;
    }

    public abstract String getExplanation();

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.targetNode);
        if (this.nodeDecisions != null) {
            out.writeBoolean(true);
            out.writeCollection(this.nodeDecisions);
        } else {
            out.writeBoolean(false);
        }
    }

    protected void checkDecisionState() {
        if (!this.isDecisionTaken()) {
            throw new IllegalStateException("decision was not taken, individual object fields cannot be accessed");
        }
    }

    public static XContentBuilder discoveryNodeToXContent(DiscoveryNode node, boolean outerObjectWritten, XContentBuilder builder) throws IOException {
        builder.field(outerObjectWritten ? "id" : "node_id", node.getId());
        builder.field(outerObjectWritten ? "name" : "node_name", node.getName());
        builder.field("transport_address", node.getAddress().toString());
        if (!node.getAttributes().isEmpty()) {
            builder.startObject(outerObjectWritten ? "attributes" : "node_attributes");
            for (Map.Entry entry : node.getAttributes().entrySet()) {
                builder.field((String)entry.getKey(), (String)entry.getValue());
            }
            builder.endObject();
        }
        builder.startArray("roles");
        for (DiscoveryNodeRole discoveryNodeRole : node.getRoles()) {
            builder.value(discoveryNodeRole.roleName());
        }
        builder.endArray();
        return builder;
    }

    public static List<NodeAllocationResult> sortNodeDecisions(List<NodeAllocationResult> nodeDecisions) {
        return nodeDecisions.stream().sorted().toList();
    }

    public static Iterator<ToXContent> nodeDecisionsToXContentChunked(List<NodeAllocationResult> nodeDecisions) {
        if (nodeDecisions == null || nodeDecisions.isEmpty()) {
            return Collections.emptyIterator();
        }
        return ChunkedToXContentHelper.array("node_allocation_decisions", nodeDecisions.iterator());
    }

    protected boolean atLeastOneNodeWithYesDecision() {
        if (this.nodeDecisions == null) {
            return false;
        }
        for (NodeAllocationResult result : this.nodeDecisions) {
            if (result.getNodeDecision() != AllocationDecision.YES) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractAllocationDecision)) {
            return false;
        }
        AbstractAllocationDecision that = (AbstractAllocationDecision)other;
        return Objects.equals(this.targetNode, that.targetNode) && Objects.equals(this.nodeDecisions, that.nodeDecisions);
    }

    public int hashCode() {
        return Objects.hash(this.targetNode, this.nodeDecisions);
    }
}

