/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.DataStreamOptions;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ResettableValue;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class Template
implements SimpleDiffable<Template>,
ToXContentObject {
    private static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    private static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private static final ParseField ALIASES = new ParseField("aliases", new String[0]);
    private static final ParseField LIFECYCLE = new ParseField("lifecycle", new String[0]);
    private static final ParseField DATA_STREAM_OPTIONS = new ParseField("data_stream_options", new String[0]);
    public static final ConstructingObjectParser<Template, Void> PARSER = new ConstructingObjectParser("template", false, a -> new Template((Settings)a[0], (CompressedXContent)a[1], (Map<String, AliasMetadata>)((Map)a[2]), (DataStreamLifecycle.Template)a[3], a[4] == null ? ResettableValue.undefined() : (ResettableValue)a[4]));
    public static final DataStreamLifecycle.Template DISABLED_LIFECYCLE = DataStreamLifecycle.dataLifecycleBuilder().enabled(false).buildTemplate();
    @Nullable
    private final Settings settings;
    @Nullable
    private final CompressedXContent mappings;
    @Nullable
    private final Map<String, AliasMetadata> aliases;
    @Nullable
    private final DataStreamLifecycle.Template lifecycle;
    private final ResettableValue<DataStreamOptions.Template> dataStreamOptions;

    public static CompressedXContent parseMappings(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return new CompressedXContent(Base64.getDecoder().decode(parser.text()));
        }
        if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
            return new CompressedXContent(parser.binaryValue());
        }
        if (token == XContentParser.Token.START_OBJECT) {
            return new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(parser.mapOrdered())));
        }
        throw new IllegalArgumentException("Unexpected token: " + String.valueOf(token));
    }

    public Template(@Nullable Settings settings, @Nullable CompressedXContent mappings, @Nullable Map<String, AliasMetadata> aliases, @Nullable DataStreamLifecycle.Template lifecycle, ResettableValue<DataStreamOptions.Template> dataStreamOptions) {
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
        assert (lifecycle == null || !lifecycle.toDataStreamLifecycle().targetsFailureStore()) : "Invalid lifecycle type for data lifecycle";
        this.lifecycle = lifecycle;
        assert (dataStreamOptions != null) : "Template does not accept null values, please use Resettable.undefined()";
        this.dataStreamOptions = dataStreamOptions;
    }

    public Template(@Nullable Settings settings, @Nullable CompressedXContent mappings, @Nullable Map<String, AliasMetadata> aliases, @Nullable DataStreamLifecycle.Template lifecycle, @Nullable DataStreamOptions.Template dataStreamOptions) {
        this.settings = settings;
        this.mappings = mappings;
        this.aliases = aliases;
        this.lifecycle = lifecycle;
        this.dataStreamOptions = ResettableValue.create(dataStreamOptions);
    }

    public Template(@Nullable Settings settings, @Nullable CompressedXContent mappings, @Nullable Map<String, AliasMetadata> aliases) {
        this(settings, mappings, aliases, null, ResettableValue.undefined());
    }

    public Template(StreamInput in) throws IOException {
        boolean isExplicitNull;
        this.settings = in.readBoolean() ? Settings.readSettingsFromStream(in) : null;
        this.mappings = in.readBoolean() ? CompressedXContent.readCompressedString(in) : null;
        this.aliases = in.readBoolean() ? in.readMap(AliasMetadata::new) : null;
        this.lifecycle = in.getTransportVersion().onOrAfter(DataStreamLifecycle.ADDED_ENABLED_FLAG_VERSION) ? in.readOptionalWriteable(DataStreamLifecycle.Template::read) : (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X) ? ((isExplicitNull = in.readBoolean()) ? DISABLED_LIFECYCLE : in.readOptionalWriteable(DataStreamLifecycle.Template::read)) : null);
        this.dataStreamOptions = ResettableValue.read(in, DataStreamOptions.Template::read);
    }

    @Nullable
    public Settings settings() {
        return this.settings;
    }

    @Nullable
    public CompressedXContent mappings() {
        return this.mappings;
    }

    @Nullable
    public Map<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    @Nullable
    public DataStreamLifecycle.Template lifecycle() {
        return this.lifecycle;
    }

    @Nullable
    public DataStreamOptions.Template dataStreamOptions() {
        return this.dataStreamOptions.get();
    }

    public ResettableValue<DataStreamOptions.Template> resettableDataStreamOptions() {
        return this.dataStreamOptions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.settings.writeTo(out);
        }
        if (this.mappings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mappings.writeTo(out);
        }
        if (this.aliases == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeMap(this.aliases, StreamOutput::writeWriteable);
        }
        if (out.getTransportVersion().onOrAfter(DataStreamLifecycle.ADDED_ENABLED_FLAG_VERSION)) {
            out.writeOptionalWriteable(this.lifecycle);
        } else if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
            boolean isExplicitNull = this.lifecycle != null && !this.lifecycle.enabled();
            out.writeBoolean(isExplicitNull);
            if (!isExplicitNull) {
                out.writeOptionalWriteable(this.lifecycle);
            }
        }
        ResettableValue.write(out, this.dataStreamOptions, (o, v) -> v.writeTo(o));
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.mappings, this.aliases, this.lifecycle, this.dataStreamOptions);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Template other = (Template)obj;
        return Objects.equals(this.settings, other.settings) && Template.mappingsEquals(this.mappings, other.mappings) && Objects.equals(this.aliases, other.aliases) && Objects.equals(this.lifecycle, other.lifecycle) && Objects.equals(this.dataStreamOptions, other.dataStreamOptions);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.toXContent(builder, params, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, @Nullable RolloverConfiguration rolloverConfiguration) throws IOException {
        builder.startObject();
        if (this.settings != null) {
            builder.startObject(SETTINGS.getPreferredName());
            this.settings.toXContent(builder, params);
            builder.endObject();
        }
        if (this.mappings != null) {
            String context = params.param("context_mode", Metadata.CONTEXT_MODE_API);
            boolean binary = params.paramAsBoolean("binary", false);
            if (Metadata.CONTEXT_MODE_API.equals(context) || !binary) {
                Map uncompressedMapping = (Map)XContentHelper.convertToMap(this.mappings.uncompressed(), true, XContentType.JSON).v2();
                if (uncompressedMapping.size() > 0) {
                    builder.field(MAPPINGS.getPreferredName());
                    builder.map(Template.reduceMapping(uncompressedMapping));
                }
            } else {
                builder.field(MAPPINGS.getPreferredName(), this.mappings.compressed());
            }
        }
        if (this.aliases != null) {
            builder.startObject(ALIASES.getPreferredName());
            for (AliasMetadata alias : this.aliases.values()) {
                AliasMetadata.Builder.toXContent(alias, builder, params);
            }
            builder.endObject();
        }
        if (this.lifecycle != null) {
            builder.field(LIFECYCLE.getPreferredName());
            this.lifecycle.toXContent(builder, params, rolloverConfiguration, null, false);
        }
        this.dataStreamOptions.toXContent(builder, params, DATA_STREAM_OPTIONS.getPreferredName());
        builder.endObject();
        return builder;
    }

    static Map<String, Object> reduceMapping(Map<String, Object> mapping) {
        if (mapping.size() == 1 && "_doc".equals(mapping.keySet().iterator().next())) {
            return (Map)mapping.values().iterator().next();
        }
        return mapping;
    }

    static boolean mappingsEquals(CompressedXContent m1, CompressedXContent m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        if (m1.equals(m2)) {
            return true;
        }
        Map<String, Object> thisUncompressedMapping = Template.reduceMapping((Map)XContentHelper.convertToMap(m1.uncompressed(), true, XContentType.JSON).v2());
        Map<String, Object> otherUncompressedMapping = Template.reduceMapping((Map)XContentHelper.convertToMap(m2.uncompressed(), true, XContentType.JSON).v2());
        return Maps.deepEquals(thisUncompressedMapping, otherUncompressedMapping);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@Nullable Template template) {
        return template == null ? new Builder() : new Builder(template);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Settings.fromXContent(p), SETTINGS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> Template.parseMappings(p), MAPPINGS, ObjectParser.ValueType.VALUE_OBJECT_ARRAY);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            XContentParser.Token token;
            HashMap<String, AliasMetadata> aliasMap = new HashMap<String, AliasMetadata>();
            while ((token = p.nextToken()) != XContentParser.Token.END_OBJECT && token != null) {
                AliasMetadata alias = AliasMetadata.Builder.fromXContent(p);
                aliasMap.put(alias.alias(), alias);
            }
            return aliasMap;
        }, ALIASES);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataStreamLifecycle.Template.dataLifecycleTemplatefromXContent(p), LIFECYCLE);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ResettableValue.create(DataStreamOptions.Template.fromXContent(p)), ResettableValue.reset(), DATA_STREAM_OPTIONS);
    }

    public static class Builder {
        private Settings settings = null;
        private CompressedXContent mappings = null;
        private Map<String, AliasMetadata> aliases = null;
        private DataStreamLifecycle.Template lifecycle = null;
        private ResettableValue<DataStreamOptions.Template> dataStreamOptions = ResettableValue.undefined();

        private Builder() {
        }

        private Builder(Template template) {
            this.settings = template.settings;
            this.mappings = template.mappings;
            this.aliases = template.aliases;
            this.lifecycle = template.lifecycle;
            this.dataStreamOptions = template.dataStreamOptions;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder mappings(CompressedXContent mappings) {
            this.mappings = mappings;
            return this;
        }

        public Builder aliases(Map<String, AliasMetadata> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder lifecycle(DataStreamLifecycle.Template lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public Builder lifecycle(DataStreamLifecycle.Builder lifecycle) {
            this.lifecycle = lifecycle.buildTemplate();
            return this;
        }

        public Builder dataStreamOptions(@Nullable DataStreamOptions.Template dataStreamOptions) {
            this.dataStreamOptions = ResettableValue.create(dataStreamOptions);
            return this;
        }

        public Builder dataStreamOptions(ResettableValue<DataStreamOptions.Template> dataStreamOptions) {
            this.dataStreamOptions = dataStreamOptions;
            return this;
        }

        public Template build() {
            return new Template(this.settings, this.mappings, this.aliases, this.lifecycle, this.dataStreamOptions);
        }
    }
}

