/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.DataStreamFailureStoreDefinition;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.MetadataCreateDataStreamService;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataMigrateToDataStreamService {
    private static final Logger logger = LogManager.getLogger(MetadataMigrateToDataStreamService.class);
    private static final CompressedXContent TIMESTAMP_MAPPING;
    private final ClusterService clusterService;
    private final IndicesService indexServices;
    private final ThreadContext threadContext;
    private final MetadataCreateIndexService metadataCreateIndexService;
    private final boolean isDslOnlyMode;

    public MetadataMigrateToDataStreamService(ThreadPool threadPool, ClusterService clusterService, IndicesService indexServices, MetadataCreateIndexService metadataCreateIndexService) {
        this.clusterService = clusterService;
        this.indexServices = indexServices;
        this.threadContext = threadPool.getThreadContext();
        this.metadataCreateIndexService = metadataCreateIndexService;
        this.isDslOnlyMode = DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(clusterService.getSettings());
    }

    public void migrateToDataStream(final ProjectId projectId, final MigrateToDataStreamClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> finalListener) {
        this.metadataCreateIndexService.getSystemIndices().validateDataStreamAccess(request.aliasName, this.threadContext);
        final AtomicReference writeIndexRef = new AtomicReference();
        ActionListener<AcknowledgedResponse> listener = finalListener.delegateFailureAndWrap((delegate, response) -> {
            if (response.isAcknowledged()) {
                String writeIndexName = (String)writeIndexRef.get();
                assert (writeIndexName != null);
                ActiveShardsObserver.waitForActiveShards(this.clusterService, projectId, new String[]{writeIndexName}, ActiveShardCount.DEFAULT, request.masterNodeTimeout(), delegate.map(shardsAcknowledged -> AcknowledgedResponse.TRUE));
            } else {
                delegate.onResponse(AcknowledgedResponse.FALSE);
            }
        });
        final AllocationActionListener<AcknowledgedResponse> delegate2 = new AllocationActionListener<AcknowledgedResponse>(listener, this.threadContext);
        this.submitUnbatchedTask("migrate-to-data-stream [" + request.aliasName + "]", new AckedClusterStateUpdateTask(Priority.HIGH, request.masterNodeTimeout(), request.ackTimeout(), delegate2.clusterStateUpdate()){

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ClusterState clusterState = MetadataMigrateToDataStreamService.migrateToDataStream(currentState.projectState(projectId), MetadataMigrateToDataStreamService.this.isDslOnlyMode, indexMetadata -> {
                    try {
                        return MetadataMigrateToDataStreamService.this.indexServices.createIndexMapperServiceForValidation((IndexMetadata)indexMetadata);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }, request, MetadataMigrateToDataStreamService.this.metadataCreateIndexService, MetadataMigrateToDataStreamService.this.clusterService.getSettings(), delegate2.reroute());
                writeIndexRef.set(clusterState.metadata().getProject(projectId).dataStreams().get(request.aliasName).getWriteIndex().getName());
                return clusterState;
            }
        });
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState migrateToDataStream(ProjectState projectState, boolean isDslOnlyMode, Function<IndexMetadata, MapperService> mapperSupplier, MigrateToDataStreamClusterStateUpdateRequest request, MetadataCreateIndexService metadataCreateIndexService, Settings settings, ActionListener<Void> listener) throws Exception {
        ProjectMetadata project = projectState.metadata();
        MetadataMigrateToDataStreamService.validateRequest(project, request);
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)project.getIndicesLookup().get(request.aliasName);
        MetadataMigrateToDataStreamService.validateBackingIndices(project, request.aliasName);
        ProjectMetadata.Builder mb = ProjectMetadata.builder(project);
        for (Index index : alias.getIndices()) {
            IndexMetadata im = project.index(index);
            MetadataMigrateToDataStreamService.prepareBackingIndex(mb, im, request.aliasName, mapperSupplier, true, false, false, Settings.EMPTY);
        }
        ClusterState updatedState = ClusterState.builder(projectState.cluster()).putProjectMetadata(mb).build();
        Index writeIndex = alias.getWriteIndex();
        List<IndexMetadata> backingIndices = alias.getIndices().stream().filter(x -> writeIndex == null || !x.equals(writeIndex)).map(x -> updatedState.metadata().getProject(project.id()).index((Index)x)).toList();
        logger.info("submitting request to migrate alias [{}] to a data stream", (Object)request.aliasName);
        MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest req = new MetadataCreateDataStreamService.CreateDataStreamClusterStateUpdateRequest(project.id(), request.aliasName);
        return MetadataCreateDataStreamService.createDataStream(metadataCreateIndexService, settings, updatedState, isDslOnlyMode, req, backingIndices, updatedState.metadata().getProject(project.id()).index(writeIndex), listener, false);
    }

    static void validateRequest(ProjectMetadata project, MigrateToDataStreamClusterStateUpdateRequest request) {
        IndexAbstraction ia = (IndexAbstraction)project.getIndicesLookup().get(request.aliasName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] does not exist");
        }
        if (ia.getWriteIndex() == null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] must specify a write index");
        }
        AliasMetadata aliasMetadata = AliasMetadata.getFirstAliasMetadata(project, ia);
        assert (aliasMetadata != null) : "alias metadata may not be null";
        if (aliasMetadata.filteringRequired() || aliasMetadata.getIndexRouting() != null || aliasMetadata.getSearchRouting() != null) {
            throw new IllegalArgumentException("alias [" + request.aliasName + "] may not have custom filtering or routing");
        }
    }

    static void prepareBackingIndex(ProjectMetadata.Builder b, IndexMetadata im, String dataStreamName, Function<IndexMetadata, MapperService> mapperSupplier, boolean removeAlias, boolean failureStore, boolean makeSystem, Settings nodeSettings) throws IOException {
        MappingMetadata mm = im.mapping();
        if (mm == null || mm.equals(MappingMetadata.EMPTY_MAPPINGS)) {
            throw new IllegalArgumentException("backing index [" + im.getIndex().getName() + "] must have mappings for a timestamp field");
        }
        MapperService mapperService = mapperSupplier.apply(im);
        mapperService.merge(im, MapperService.MergeReason.MAPPING_RECOVERY);
        mapperService.merge("_doc", TIMESTAMP_MAPPING, MapperService.MergeReason.MAPPING_UPDATE);
        DocumentMapper mapper = mapperService.documentMapper();
        IndexMetadata.Builder imb = IndexMetadata.builder(im);
        if (removeAlias) {
            imb.removeAlias(dataStreamName);
        }
        Settings.Builder settingsUpdate = Settings.builder().put(im.getSettings()).put("index.hidden", true);
        if (failureStore) {
            DataStreamFailureStoreDefinition.applyFailureStoreSettings(nodeSettings, settingsUpdate);
        }
        Settings maybeUpdatedSettings = settingsUpdate.build();
        if (!IndexSettings.same(im.getSettings(), maybeUpdatedSettings)) {
            imb.settings(maybeUpdatedSettings).settingsVersion(im.getSettingsVersion() + 1L);
        }
        imb.mappingVersion(im.getMappingVersion() + 1L).mappingsUpdatedVersion(IndexVersion.current()).putMapping(new MappingMetadata(mapper));
        imb.system(makeSystem);
        b.put(imb);
    }

    static void validateBackingIndices(ProjectMetadata project, String dataStreamName) {
        IndexAbstraction ia = (IndexAbstraction)project.getIndicesLookup().get(dataStreamName);
        if (ia == null || ia.getType() != IndexAbstraction.Type.ALIAS) {
            throw new IllegalArgumentException("alias [" + dataStreamName + "] does not exist");
        }
        IndexAbstraction.Alias alias = (IndexAbstraction.Alias)ia;
        ArrayList<String> indicesWithOtherAliases = new ArrayList<String>();
        for (Index index : alias.getIndices()) {
            IndexMetadata im = project.index(index);
            if (im.getAliases().size() <= 1 && im.getAliases().containsKey(alias.getName())) continue;
            indicesWithOtherAliases.add(index.getName());
        }
        if (indicesWithOtherAliases.size() > 0) {
            throw new IllegalArgumentException("other aliases referencing indices [" + Strings.collectionToCommaDelimitedString(indicesWithOtherAliases) + "] must be removed before migrating to a data stream");
        }
    }

    static {
        try {
            TIMESTAMP_MAPPING = new CompressedXContent((builder, params) -> builder.startObject("_data_stream_timestamp").field("enabled", true).endObject());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public record MigrateToDataStreamClusterStateUpdateRequest(String aliasName, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
        public MigrateToDataStreamClusterStateUpdateRequest {
            Objects.requireNonNull(aliasName);
            Objects.requireNonNull(masterNodeTimeout);
            Objects.requireNonNull(ackTimeout);
        }
    }
}

