/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.DesiredNodes;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class DesiredNodesMetadata
extends AbstractNamedDiffable<Metadata.ClusterCustom>
implements Metadata.ClusterCustom {
    public static final String TYPE = "desired_nodes";
    public static final DesiredNodesMetadata EMPTY = new DesiredNodesMetadata((DesiredNodes)null);
    private static final ParseField LATEST_FIELD = new ParseField("latest", new String[0]);
    private static final ConstructingObjectParser<DesiredNodesMetadata, Void> PARSER = new ConstructingObjectParser("desired_nodes", false, (args, unused) -> new DesiredNodesMetadata((DesiredNodes)args[0]));
    private final DesiredNodes latestDesiredNodes;

    public DesiredNodesMetadata(DesiredNodes latestDesiredNodes) {
        this.latestDesiredNodes = latestDesiredNodes;
    }

    public DesiredNodesMetadata(StreamInput in) throws IOException {
        this.latestDesiredNodes = DesiredNodes.readFrom(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.latestDesiredNodes.writeTo(out);
    }

    public static NamedDiff<Metadata.ClusterCustom> readDiffFrom(StreamInput in) throws IOException {
        return DesiredNodesMetadata.readDiffFrom(Metadata.ClusterCustom.class, TYPE, in);
    }

    public static DesiredNodesMetadata fromXContent(XContentParser parser) throws IOException {
        return (DesiredNodesMetadata)PARSER.parse(parser, null);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> builder.field(LATEST_FIELD.getPreferredName(), (ToXContent)this.latestDesiredNodes, params));
    }

    public static DesiredNodesMetadata fromClusterState(ClusterState clusterState) {
        return clusterState.metadata().custom(TYPE, EMPTY);
    }

    @Nullable
    public DesiredNodes getLatestDesiredNodes() {
        return this.latestDesiredNodes;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.API_AND_GATEWAY;
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.minimumCompatible();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DesiredNodesMetadata that = (DesiredNodesMetadata)o;
        return Objects.equals(this.latestDesiredNodes, that.latestDesiredNodes);
    }

    public int hashCode() {
        return Objects.hash(this.latestDesiredNodes);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DesiredNodes.fromXContent(p), LATEST_FIELD);
    }
}

