/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;

public class CleanableResponseHandler<T extends TransportResponse>
extends ActionListenerResponseHandler<T> {
    private final Runnable cleanup;

    public CleanableResponseHandler(ActionListener<? super T> listener, Writeable.Reader<T> reader, Executor executor, Runnable cleanup) {
        super(ActionListener.runAfter(listener, cleanup), reader, executor);
        this.cleanup = cleanup;
    }

    public void runCleanup() {
        assert (ThreadPool.assertCurrentThreadPool(new String[0]));
        this.cleanup.run();
    }
}

